/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.OrderByClause;
import com.huawei.hwclouds.migration.oracle.model.OverClause;
import com.huawei.hwclouds.migration.oracle.model.QueryPartitionClause;
import com.huawei.hwclouds.migration.oracle.model.SubQuery;
import com.huawei.hwclouds.migration.oracle.model.WindowingClause;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.OrderByClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SubQueryVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.WindowingClauseVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class OverClauseVisitor
extends AbstractVisitor<OverClause> {
    private OverClause overClause = new OverClause();

    @Override
    protected OverClause defaultResult() {
        return this.overClause;
    }

    @Override
    public OverClause visitOverClause(OracleParser.OverClauseContext ctx) {
        if (ctx.queryPartitionClause() != null) {
            this.overClause.setQueryPartitionClause(this.getQueryPartition(ctx.queryPartitionClause()));
        }
        if (ctx.orderByClause() != null) {
            OrderByClause orderByClause = (OrderByClause)new OrderByClauseVisitor().visit((ParseTree)ctx.orderByClause());
            this.overClause.setOrderByClause(orderByClause);
        }
        if (ctx.windowingClause() != null) {
            WindowingClause windowingClause = (WindowingClause)new WindowingClauseVisitor().visit((ParseTree)ctx.windowingClause());
            this.overClause.setWindowingClause(windowingClause);
        }
        return this.defaultResult();
    }

    private QueryPartitionClause getQueryPartition(OracleParser.QueryPartitionClauseContext queryPartition) {
        QueryPartitionClause partitionClause = new QueryPartitionClause();
        partitionClause.setBrackets(queryPartition.LEFT_PAREN() != null);
        if (queryPartition.expressions() != null) {
            SqlNodeList<Expression> expressions = new SqlNodeList<Expression>();
            List<OracleParser.ExpressionContext> expressionList = queryPartition.expressions().expression();
            for (int i = 0; i < expressionList.size(); ++i) {
                expressions.addNode((Expression)new ExpressionVisitor().visit((ParseTree)expressionList.get(i)));
            }
            partitionClause.setExpressionList(expressions);
        }
        if (queryPartition.subQuery() != null) {
            partitionClause.setSubQuery((SubQuery)new SubQueryVisitor().visit((ParseTree)queryPartition.subQuery()));
        }
        return partitionClause;
    }
}

