/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.QueryTableExpression;
import com.huawei.hwclouds.migration.oracle.model.SampleClause;
import com.huawei.hwclouds.migration.oracle.model.SubQuery;
import com.huawei.hwclouds.migration.oracle.model.SubQueryRestriction;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SubQueryVisitor;
import com.huawei.hwclouds.migration.oracle.util.UidInKeyWord;
import org.antlr.v4.runtime.tree.ParseTree;

public class QueryTableExpressionVisitor
extends AbstractVisitor<QueryTableExpression> {
    private QueryTableExpression queryTableExpression = new QueryTableExpression();

    @Override
    protected QueryTableExpression defaultResult() {
        return this.queryTableExpression;
    }

    @Override
    public QueryTableExpression visitDmlTableExpTableCollection(OracleParser.DmlTableExpTableCollectionContext ctx) {
        return this.defaultResult();
    }

    @Override
    public QueryTableExpression visitDmlTableExpSubQuery(OracleParser.DmlTableExpSubQueryContext ctx) {
        this.queryTableExpression.setLateral(ctx.LATERAL() != null);
        this.queryTableExpression.setSubQuery((SubQuery)new SubQueryVisitor().visit((ParseTree)ctx.subQuery()));
        if (ctx.subQueryRestrictionClause() != null) {
            SubQueryRestriction subQueryRestriction = new SubQueryRestriction();
            if (ctx.subQueryRestrictionClause().READ() != null) {
                subQueryRestriction.setWithType("READ ONLY");
            } else {
                subQueryRestriction.setWithType("CHECK OPTION");
            }
            if (ctx.subQueryRestrictionClause().constraintName() != null) {
                String constraintName = ctx.subQueryRestrictionClause().constraintName().getText();
                subQueryRestriction.setConstraintName(new Identifier(constraintName));
            }
            this.queryTableExpression.setSubQueryRestriction(subQueryRestriction);
        }
        return this.defaultResult();
    }

    @Override
    public QueryTableExpression visitDmlTableExpTableViewName(OracleParser.DmlTableExpTableViewNameContext ctx) {
        this.queryTableExpression.setTableName(UidInKeyWord.getUid(ctx.tableviewName().getText()));
        if (ctx.sampleClause() != null) {
            SampleClause sampleClause = new SampleClause();
            sampleClause.setBlock(ctx.sampleClause().BLOCK() != null);
            sampleClause.setSamplePercent((Expression)new ExpressionVisitor().visit((ParseTree)ctx.sampleClause().expression()));
            if (ctx.sampleClause().seedPart() != null) {
                sampleClause.setSeedValue((Expression)new ExpressionVisitor().visit((ParseTree)ctx.sampleClause().seedPart().expression()));
            }
            this.queryTableExpression.setSampleClause(sampleClause);
        }
        return this.defaultResult();
    }
}

