/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.ColumnDefinition;
import com.huawei.hwclouds.migration.oracle.model.ColumnProperties;
import com.huawei.hwclouds.migration.oracle.model.ParallelClause;
import com.huawei.hwclouds.migration.oracle.model.PhysicalProperties;
import com.huawei.hwclouds.migration.oracle.model.RelationalProperty;
import com.huawei.hwclouds.migration.oracle.model.RelationalTable;
import com.huawei.hwclouds.migration.oracle.model.TableConstraint;
import com.huawei.hwclouds.migration.oracle.model.TablePartitioningClauses;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ColumnPropertiesVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ParallelClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.PhysicalPropertiesVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SqlColumnDefinitionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SqlTableConstraintVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TablePartitioningClausesVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class RelationalTableVisitor
extends AbstractVisitor<RelationalTable> {
    private RelationalTable relationalTable = new RelationalTable();

    @Override
    protected RelationalTable defaultResult() {
        return this.relationalTable;
    }

    @Override
    public RelationalTable visitRelationalTable(OracleParser.RelationalTableContext ctx) {
        SqlNodeList<RelationalProperty> relationalPropertySqlNodeList = new SqlNodeList<RelationalProperty>();
        for (int i = 0; i < ctx.relationalProperty().size(); ++i) {
            relationalPropertySqlNodeList.addNode(this.getRelationalProperty(ctx.relationalProperty().get(i)));
        }
        this.relationalTable.setRelationalPropertySqlNodeList(relationalPropertySqlNodeList);
        if (ctx.DELETE() != null) {
            this.relationalTable.setCommitInfo("DELETE");
        } else if (ctx.PRESERVE() != null) {
            this.relationalTable.setCommitInfo("PRESERVE");
        }
        if (ctx.physicalProperties() != null) {
            this.relationalTable.setPhysicalProperties((PhysicalProperties)new PhysicalPropertiesVisitor().visit((ParseTree)ctx.physicalProperties()));
        }
        if (ctx.columnProperties().size() > 0) {
            SqlNodeList<ColumnProperties> columnPropertiesSqlNodeList = new SqlNodeList<ColumnProperties>();
            for (int i = 0; i < ctx.columnProperties().size(); ++i) {
                columnPropertiesSqlNodeList.addNode((ColumnProperties)new ColumnPropertiesVisitor().visit((ParseTree)ctx.columnProperties().get(i)));
            }
            this.relationalTable.setColumnPropertiesSqlNodeList(columnPropertiesSqlNodeList);
        }
        if (ctx.tablePartitioningClauses() != null) {
            this.relationalTable.setTablePartitioningClauses((TablePartitioningClauses)new TablePartitioningClausesVisitor().visit((ParseTree)ctx.tablePartitioningClauses()));
        }
        if (ctx.parallelClause() != null) {
            this.relationalTable.setParallelClause((ParallelClause)new ParallelClauseVisitor().visit((ParseTree)ctx.parallelClause()));
        }
        return this.defaultResult();
    }

    private RelationalProperty getRelationalProperty(OracleParser.RelationalPropertyContext ctx) {
        RelationalProperty relationalProperty = new RelationalProperty();
        if (ctx.columnDefinition() != null) {
            ColumnDefinition columnDefinition = (ColumnDefinition)new SqlColumnDefinitionVisitor().visit((ParseTree)ctx.columnDefinition());
            relationalProperty.setColumnDefinition(columnDefinition);
        } else if (ctx.outOfLineConstraint() != null) {
            TableConstraint tableConstraint = (TableConstraint)new SqlTableConstraintVisitor().visit((ParseTree)ctx.outOfLineConstraint());
            relationalProperty.setTableConstraint(tableConstraint);
        } else if (ctx.supplementalLoggingProps() != null) {
            String supplementalLoggingProps = "SUPPLEMENTAL LOG ";
            OracleParser.SupplementalLogGrpClauseContext supplementalLogGrpClauseContext = ctx.supplementalLoggingProps().supplementalLogGrpClause();
            OracleParser.SupplementalIdKeyClauseContext supplementalIdKeyClauseContext = ctx.supplementalLoggingProps().supplementalIdKeyClause();
            if (supplementalLogGrpClauseContext != null) {
                for (int i = 0; i < supplementalLogGrpClauseContext.getChildCount(); ++i) {
                    supplementalLoggingProps = supplementalLoggingProps + supplementalLogGrpClauseContext.getChild(i).getText() + " ";
                }
            } else {
                for (int i = 0; i < supplementalIdKeyClauseContext.getChildCount(); ++i) {
                    supplementalLoggingProps = supplementalLoggingProps + supplementalIdKeyClauseContext.getChild(i).getText() + " ";
                }
            }
            relationalProperty.setSupplementalLoggingProps(supplementalLoggingProps);
        }
        return relationalProperty;
    }
}

