/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.ColumnAlias;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.SelectListElement;
import com.huawei.hwclouds.migration.oracle.model.TableName;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TableNameVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class SelectListElementVisitor
extends AbstractVisitor<SelectListElement> {
    private SelectListElement selectListElement = new SelectListElement();

    @Override
    protected SelectListElement defaultResult() {
        return this.selectListElement;
    }

    @Override
    public SelectListElement visitSelectListElements(OracleParser.SelectListElementsContext ctx) {
        if (ctx.tableviewName() != null) {
            TableName tableName = (TableName)new TableNameVisitor().visit((ParseTree)ctx.tableviewName());
            this.selectListElement.setTableName(tableName);
        }
        if (ctx.expression() != null) {
            Expression expression = (Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression());
            this.selectListElement.setExpression(expression);
        }
        if (ctx.columnAlias() != null) {
            ColumnAlias columnAlias = new ColumnAlias();
            if (ctx.columnAlias().AS() != null) {
                columnAlias.setExistAs(true);
            }
            if (ctx.columnAlias().identifier() != null) {
                columnAlias.setAliasName(ctx.columnAlias().identifier().getText());
            }
            if (ctx.columnAlias().quotedString() != null) {
                columnAlias.setAliasName(ctx.columnAlias().quotedString().getText());
            }
            this.selectListElement.setExpAlias(columnAlias);
        }
        return this.defaultResult();
    }

    private String getAlias(OracleParser.ColumnAliasContext columnAliasContext) {
        StringBuffer stringBuffer = new StringBuffer();
        if (columnAliasContext.AS() != null) {
            stringBuffer.append("AS ");
        }
        if (columnAliasContext.quotedString() != null) {
            stringBuffer.append(columnAliasContext.quotedString().getText());
        }
        if (columnAliasContext.identifier() != null) {
            stringBuffer.append(columnAliasContext.identifier().getText());
        }
        return stringBuffer.toString();
    }
}

