/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.CheckConstraint;
import com.huawei.hwclouds.migration.oracle.model.ColumnDefinition;
import com.huawei.hwclouds.migration.oracle.model.ConstraintState;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.SqlLiteral;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.CheckConstraintVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ConstraintStateVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.DefaultValueVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SqlDatatypeVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class SqlColumnDefinitionVisitor
extends AbstractVisitor<ColumnDefinition> {
    ColumnDefinition columnDefinition = new ColumnDefinition();

    @Override
    protected ColumnDefinition defaultResult() {
        return this.columnDefinition;
    }

    @Override
    public ColumnDefinition visitColumnDefinition(OracleParser.ColumnDefinitionContext ctx) {
        List<OracleParser.InlineConstraintContext> inlineConstraints;
        this.columnDefinition.setColumnName(new Identifier(ctx.columnName().getText()));
        if (ctx.datatype() != null) {
            this.columnDefinition.setDataType(new SqlDatatypeVisitor().visitDatatype(ctx.datatype()));
        }
        if (ctx.typeName() != null) {
            this.visit((ParseTree)ctx.typeName());
        }
        if ((inlineConstraints = ctx.inlineConstraint()) != null) {
            for (int i = 0; i < inlineConstraints.size(); ++i) {
                this.visit((ParseTree)inlineConstraints.get(i));
            }
        }
        if (ctx.DEFAULT() != null) {
            SqlLiteral defaultValue = (SqlLiteral)new DefaultValueVisitor().visit((ParseTree)ctx.defaultValue());
            this.columnDefinition.setDefaultValue(defaultValue);
        }
        return this.defaultResult();
    }

    @Override
    public ColumnDefinition visitTypeName(OracleParser.TypeNameContext ctx) {
        this.columnDefinition.setTypeName(new Identifier(ctx.getText()));
        return this.defaultResult();
    }

    @Override
    public ColumnDefinition visitInlineConstraint(OracleParser.InlineConstraintContext ctx) {
        if (ctx.PRIMARY() != null) {
            this.columnDefinition.setPrimaryKey(true);
        }
        if (ctx.UNIQUE() != null) {
            this.columnDefinition.setUniqueKey(true);
        }
        if (ctx.NOT() != null && ctx.NULL_() != null) {
            this.columnDefinition.setNonNotNon(SqlLiteral.setNonNotNon(false));
        }
        if (ctx.NOT() == null && ctx.NULL_() != null) {
            this.columnDefinition.setNonNotNon(SqlLiteral.setNonNotNon(true));
        }
        if (ctx.checkConstraint() != null) {
            this.columnDefinition.setCheckConstraint((CheckConstraint)new CheckConstraintVisitor().visit((ParseTree)ctx.checkConstraint()));
        }
        if (ctx.constraintState() != null && ctx.constraintState().size() > 0) {
            for (int i = 0; i < ctx.constraintState().size(); ++i) {
                this.columnDefinition.addConstraintStates((ConstraintState)new ConstraintStateVisitor().visit((ParseTree)ctx.constraintState().get(i)));
            }
        }
        return this.defaultResult();
    }

    @Override
    public ColumnDefinition visitModifyColProperties(OracleParser.ModifyColPropertiesContext ctx) {
        this.columnDefinition.setColumnName(new Identifier(ctx.columnName().getText()));
        if (ctx.datatype() != null) {
            this.columnDefinition.setDataType(new SqlDatatypeVisitor().visitDatatype(ctx.datatype()));
        }
        if (ctx.DEFAULT() != null) {
            SqlLiteral defaultValue = (SqlLiteral)new DefaultValueVisitor().visit((ParseTree)ctx.defaultValue());
            this.columnDefinition.setDefaultValue(defaultValue);
        }
        if (ctx.inlineConstraint() != null) {
            for (int i = 0; i < ctx.inlineConstraint().size(); ++i) {
                this.visitInlineConstraint(ctx.inlineConstraint(i));
            }
        }
        return this.defaultResult();
    }
}

