/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.DataType;
import com.huawei.hwclouds.migration.oracle.model.SqlTypeName;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;

public class SqlDatatypeVisitor
extends AbstractVisitor<DataType> {
    private DataType dataType = new DataType();

    @Override
    protected DataType defaultResult() {
        return this.dataType;
    }

    @Override
    public DataType visitDatatype(OracleParser.DatatypeContext ctx) {
        String typeName = this.getTypeName(ctx.nativeDatatypeElement().getText());
        this.dataType.setTypeName(SqlTypeName.find(typeName));
        if (ctx.precisionPart() != null) {
            this.visitPrecisionPart(ctx.precisionPart());
        }
        return this.defaultResult();
    }

    private String getTypeName(String ctx) {
        return ctx.replace(" ", "");
    }

    @Override
    public DataType visitPrecisionPart(OracleParser.PrecisionPartContext ctx) {
        if (ctx.ASTERISK() != null) {
            int scale;
            this.dataType.setPrecision(38L);
            if (ctx.numeric().size() == 1) {
                scale = Integer.parseInt(ctx.numeric(0).getText());
                this.dataType.setScale(scale);
            }
            if (ctx.numericNegative() != null) {
                scale = Integer.parseInt(ctx.numericNegative().getText());
                this.dataType.setScale(scale);
            }
        } else {
            int scale;
            Long precision = Long.parseLong(ctx.numeric(0).getText());
            this.dataType.setPrecision(precision);
            if (ctx.numeric().size() == 2) {
                scale = Integer.parseInt(ctx.numeric(1).getText());
                this.dataType.setScale(scale);
            }
            if (ctx.numericNegative() != null) {
                scale = Integer.parseInt(ctx.numericNegative().getText());
                this.dataType.setScale(scale);
            }
        }
        if (ctx.CHAR() != null) {
            this.dataType.setCharset("CHAR");
        } else if (ctx.BYTE() != null) {
            this.dataType.setCharset("BYTE");
        }
        return this.defaultResult();
    }
}

