/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.AssignmentStatement;
import com.huawei.hwclouds.migration.oracle.model.BindVariable;
import com.huawei.hwclouds.migration.oracle.model.Block;
import com.huawei.hwclouds.migration.oracle.model.Body;
import com.huawei.hwclouds.migration.oracle.model.CaseStatement;
import com.huawei.hwclouds.migration.oracle.model.Condition;
import com.huawei.hwclouds.migration.oracle.model.CursorLoopParam;
import com.huawei.hwclouds.migration.oracle.model.DeclareSpec;
import com.huawei.hwclouds.migration.oracle.model.ElsifPart;
import com.huawei.hwclouds.migration.oracle.model.ExitStatement;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.FunctionArgument;
import com.huawei.hwclouds.migration.oracle.model.FunctionCall;
import com.huawei.hwclouds.migration.oracle.model.GeneralElement;
import com.huawei.hwclouds.migration.oracle.model.IfStatement;
import com.huawei.hwclouds.migration.oracle.model.KeepClause;
import com.huawei.hwclouds.migration.oracle.model.LoopStatement;
import com.huawei.hwclouds.migration.oracle.model.PipeRowStatement;
import com.huawei.hwclouds.migration.oracle.model.SeqOfStatement;
import com.huawei.hwclouds.migration.oracle.model.SqlStatement;
import com.huawei.hwclouds.migration.oracle.model.Statement;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.BindVariableVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.BodyVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.CaseStatementVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ConditionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.CursorLoopParamVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.DeclareSpecVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.FunctionArgumentVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.GeneralElementVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.KeepClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SeqOfStatementVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SqlStatementVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class StatementVisitor
extends AbstractVisitor<Statement> {
    private Statement statement = new Statement();

    @Override
    protected Statement defaultResult() {
        return this.statement;
    }

    @Override
    public Statement visitBody(OracleParser.BodyContext ctx) {
        this.statement.setBody((Body)new BodyVisitor().visit((ParseTree)ctx));
        return this.defaultResult();
    }

    @Override
    public Statement visitBlock(OracleParser.BlockContext ctx) {
        Block block = new Block();
        block.setExistDeclare(ctx.DECLARE() != null);
        SqlNodeList<DeclareSpec> declareSpecSqlNodeList = new SqlNodeList<DeclareSpec>();
        for (int i = 0; i < ctx.declareSpec().size(); ++i) {
            declareSpecSqlNodeList.addNode((DeclareSpec)new DeclareSpecVisitor().visit((ParseTree)ctx.declareSpec().get(i)));
        }
        block.setDeclareSpecSqlNodeList(declareSpecSqlNodeList);
        block.setBody((Body)new BodyVisitor().visit((ParseTree)ctx.body()));
        this.statement.setBlock(block);
        return this.defaultResult();
    }

    @Override
    public Statement visitAssignmentStatement(OracleParser.AssignmentStatementContext ctx) {
        AssignmentStatement assignmentStatement = new AssignmentStatement();
        if (ctx.generalElement() != null) {
            assignmentStatement.setGeneralElement((GeneralElement)new GeneralElementVisitor().visit((ParseTree)ctx.generalElement()));
        } else {
            assignmentStatement.setBindVariable((BindVariable)new BindVariableVisitor().visit((ParseTree)ctx.bindVariable()));
        }
        assignmentStatement.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        this.statement.setAssignmentStatement(assignmentStatement);
        return this.defaultResult();
    }

    @Override
    public Statement visitSqlStatement(OracleParser.SqlStatementContext ctx) {
        this.statement.setSqlStatement((SqlStatement)new SqlStatementVisitor().visit((ParseTree)ctx));
        return this.defaultResult();
    }

    @Override
    public Statement visitReturnStatement(OracleParser.ReturnStatementContext ctx) {
        if (ctx.expression() != null) {
            this.statement.setReturnStatement((Expression)new ExpressionVisitor().visit((ParseTree)ctx));
        } else {
            this.statement.setReturnStatement(new Expression());
        }
        return this.defaultResult();
    }

    @Override
    public Statement visitIfStatement(OracleParser.IfStatementContext ctx) {
        int i;
        IfStatement ifStatement = new IfStatement();
        ifStatement.setCondition((Condition)new ConditionVisitor().visit((ParseTree)ctx.condition()));
        SqlNodeList<SeqOfStatement> seqOfStatementSqlNodeList = new SqlNodeList<SeqOfStatement>();
        for (int i2 = 0; i2 < ctx.seqOfStatement().size(); ++i2) {
            seqOfStatementSqlNodeList.addNode((SeqOfStatement)new SeqOfStatementVisitor().visit((ParseTree)ctx.seqOfStatement().get(i2)));
        }
        ifStatement.setSeqOfStatements(seqOfStatementSqlNodeList);
        if (ctx.elsifPart() != null) {
            SqlNodeList<ElsifPart> elsifPartSqlNodeList = new SqlNodeList<ElsifPart>();
            for (i = 0; i < ctx.elsifPart().size(); ++i) {
                ElsifPart elsifPart = new ElsifPart();
                elsifPart.setCondition((Condition)new ConditionVisitor().visit((ParseTree)ctx.elsifPart().get(i).condition()));
                SqlNodeList<SeqOfStatement> elsifPartSeq = new SqlNodeList<SeqOfStatement>();
                for (int j = 0; j < ctx.elsifPart().get(i).seqOfStatement().size(); ++j) {
                    elsifPartSeq.addNode((SeqOfStatement)new SeqOfStatementVisitor().visit((ParseTree)ctx.elsifPart().get(i).seqOfStatement().get(j)));
                }
                elsifPart.setSeqOfStatements(elsifPartSeq);
                elsifPartSqlNodeList.addNode(elsifPart);
            }
            ifStatement.setElsifPartSqlNodeList(elsifPartSqlNodeList);
        }
        if (ctx.elsePart() != null) {
            SqlNodeList<SeqOfStatement> elsePartSeq = new SqlNodeList<SeqOfStatement>();
            for (i = 0; i < ctx.elsePart().seqOfStatement().size(); ++i) {
                elsePartSeq.addNode((SeqOfStatement)new SeqOfStatementVisitor().visit((ParseTree)ctx.elsePart().seqOfStatement().get(i)));
            }
            ifStatement.setElsePart(elsePartSeq);
        }
        this.statement.setIfStatement(ifStatement);
        return this.defaultResult();
    }

    @Override
    public Statement visitFunctionCall(OracleParser.FunctionCallContext ctx) {
        FunctionCall functionCall = new FunctionCall();
        functionCall.setExistCall(ctx.CALL() != null);
        functionCall.setRoutineName(ctx.routineName().getText());
        if (ctx.LEFT_PAREN() != null) {
            functionCall.setExistsBrackets(true);
        }
        if (ctx.functionArgument() != null) {
            functionCall.setFunctionArgument((FunctionArgument)new FunctionArgumentVisitor().visit((ParseTree)ctx.functionArgument()));
        }
        if (ctx.keepClause() != null) {
            functionCall.setKeepClause((KeepClause)new KeepClauseVisitor().visit((ParseTree)ctx.keepClause()));
        }
        this.statement.setFunctionCall(functionCall);
        return this.defaultResult();
    }

    @Override
    public Statement visitLoopStatement(OracleParser.LoopStatementContext ctx) {
        LoopStatement loopStatement = new LoopStatement();
        if (ctx.labelDeclaration() != null) {
            loopStatement.setLabelDeclaration(ctx.labelDeclaration().getText());
        }
        if (ctx.condition() != null) {
            loopStatement.setCondition((Condition)new ConditionVisitor().visit((ParseTree)ctx.condition()));
        } else if (ctx.cursorLoopParam() != null) {
            loopStatement.setCursorLoopParam((CursorLoopParam)new CursorLoopParamVisitor().visit((ParseTree)ctx.cursorLoopParam()));
        }
        SqlNodeList<SeqOfStatement> seqOfStatements = new SqlNodeList<SeqOfStatement>();
        for (int i = 0; i < ctx.seqOfStatement().size(); ++i) {
            seqOfStatements.addNode((SeqOfStatement)new SeqOfStatementVisitor().visit((ParseTree)ctx.seqOfStatement().get(i)));
        }
        loopStatement.setSeqOfStatements(seqOfStatements);
        if (ctx.labelName() != null) {
            loopStatement.setLabelName(ctx.labelName().getText());
        }
        this.statement.setLoopStatement(loopStatement);
        return this.defaultResult();
    }

    @Override
    public Statement visitExitStatement(OracleParser.ExitStatementContext ctx) {
        ExitStatement exitStatement = new ExitStatement();
        if (ctx.labelName() != null) {
            exitStatement.setLabelName(ctx.labelName().getText());
        }
        if (ctx.condition() != null) {
            exitStatement.setCondition((Condition)new ConditionVisitor().visit((ParseTree)ctx.condition()));
        }
        this.statement.setExitStatement(exitStatement);
        return this.defaultResult();
    }

    @Override
    public Statement visitRaiseStatement(OracleParser.RaiseStatementContext ctx) {
        if (ctx.exceptionName() != null) {
            this.statement.setRaiseStatement(ctx.exceptionName().getText());
        } else {
            this.statement.setRemoveSemicolon(true);
        }
        return this.defaultResult();
    }

    @Override
    public Statement visitNullStatement(OracleParser.NullStatementContext ctx) {
        this.statement.setNullStatement(ctx.getText());
        return this.defaultResult();
    }

    @Override
    public Statement visitCaseStatement(OracleParser.CaseStatementContext ctx) {
        this.statement.setCaseStatement((CaseStatement)new CaseStatementVisitor().visit((ParseTree)ctx));
        return this.defaultResult();
    }

    @Override
    public Statement visitPipeRowStatement(OracleParser.PipeRowStatementContext ctx) {
        PipeRowStatement pipeRowStatement = new PipeRowStatement();
        pipeRowStatement.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        this.statement.setPipeRowStatement(pipeRowStatement);
        return this.defaultResult();
    }
}

