/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.AlterTableConstraint;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.TableConstraint;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=AlterTableConstraint.class)
public class AlterTableConstraintActionUnParser
implements UnParser<AlterTableConstraint> {
    @Override
    public void unParse(AlterTableConstraint sqlNode, SqlWriter writer, UnParserContext context) {
        String option;
        switch (option = sqlNode.getOptions()) {
            case "RENAME": {
                writer.append("RENAME CONSTRAINT ").append(sqlNode.getConstraintName().getIdentifier()).append(" TO ").append(sqlNode.getNewConstraintName().getIdentifier());
                return;
            }
            case "MODIFY": {
                throw new ParserRuntimeException("Other types are not supported in DSC");
            }
            case "ADD": {
                List<TableConstraint> tableConstraints = sqlNode.getTableConstraints();
                if (tableConstraints != null) {
                    writer.append("ADD ");
                    this.dealWithConstraint(sqlNode, tableConstraints, writer, context);
                }
                return;
            }
            case "DROP": {
                List<TableConstraint> tableConstraints1 = sqlNode.getTableConstraints();
                if (tableConstraints1 != null) {
                    writer.append("DROP ");
                    this.dealWithConstraint(sqlNode, tableConstraints1, writer, context);
                }
                return;
            }
        }
    }

    private void dealWithConstraint(AlterTableConstraint sqlNode, List<TableConstraint> tableConstraints, SqlWriter writer, UnParserContext context) {
        for (int i = 0; i < tableConstraints.size(); ++i) {
            TableConstraint tableConstraint = tableConstraints.get(i);
            if (tableConstraint.getConstraintName() != null) {
                writer.writeSpace(1).append("CONSTRAINT ");
                this.alterConstraintNameByArgs(sqlNode, tableConstraint.getConstraintName(), writer, context);
            }
            if (tableConstraint.getConstraintType() != null) {
                this.getConstraintTypeContent(tableConstraint, writer, context);
            }
            if (!tableConstraint.isCascade()) continue;
            writer.writeSpace(1).append("CASCADE");
        }
    }

    private void getConstraintTypeContent(TableConstraint tableConstraint, SqlWriter writer, UnParserContext context) {
        String constraintType = tableConstraint.getConstraintType().getIdentifier();
        if (constraintType.equals("PRIMARY KEY")) {
            writer.writeSpace(1).append("PRIMARY KEY");
        }
        if (constraintType.equals("UNIQUE")) {
            writer.writeSpace(1).append("UNIQUE");
        }
        if (tableConstraint.getColumns() != null) {
            List<Identifier> nodes = tableConstraint.getColumns().getNodes();
            writer.append("(");
            for (int j = 0; j < nodes.size(); ++j) {
                writer.append(nodes.get(j).getIdentifier());
                if (j == nodes.size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
            writer.append(")");
        }
    }

    private void alterConstraintNameByArgs(AlterTableConstraint alterTableConstraint, Identifier constraintName, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(config, "table.constraint.rename", "false").equalsIgnoreCase("true")) {
            writer.writeSpace(1);
            writer.append(this.appendConstraintNameWithTableName(alterTableConstraint, constraintName));
            return;
        }
        writer.writeSpace(1);
        constraintName.unParse(writer, context);
    }

    private String appendConstraintNameWithTableName(AlterTableConstraint sqlNode, Identifier constraintName) {
        String result = sqlNode.getTableName().getTableName().getIdentifier() + "_" + QuoteUtils.removeDoubleQuote(constraintName.getIdentifier());
        if (result.length() > 63) {
            result = result.substring(0, 63);
        }
        result = QuoteUtils.addDoubleQuote(result);
        return result.toLowerCase(Locale.ROOT);
    }
}

