/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.AssignmentStatement;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.ModelExpression;
import com.huawei.hwclouds.migration.oracle.model.OtherFunction;
import com.huawei.hwclouds.migration.oracle.model.RelationalExpression;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=AssignmentStatement.class)
public class AssignmentStatementUnParser
implements UnParser<AssignmentStatement> {
    @Override
    public void unParse(AssignmentStatement sqlNode, SqlWriter writer, UnParserContext context) {
        this.dealWithRowCount(sqlNode);
        if (sqlNode.isExistSqlRowCount()) {
            writer.append("GET DIAGNOSTICS ");
            sqlNode.getGeneralElement().unParse(writer, context);
            writer.append("= ").append("ROW_COUNT");
        } else {
            if (sqlNode.getGeneralElement() != null) {
                sqlNode.getGeneralElement().unParse(writer, context);
            } else {
                sqlNode.getBindVariable().unParse(writer, context);
            }
            writer.append(":= ");
            sqlNode.getExpression().unParse(writer, context);
        }
    }

    private void dealWithRowCount(AssignmentStatement assignmentStatement) {
        Expression expression;
        if (assignmentStatement.getExpression() != null && (expression = assignmentStatement.getExpression()).getLogicalExpression() != null && expression.getLogicalExpression().getMultisetExpression() != null && expression.getLogicalExpression().getMultisetExpression().getRelationalExpression() != null) {
            this.unParseRelationalExpression(assignmentStatement, expression);
        }
    }

    private void unParseRelationalExpression(AssignmentStatement assignmentStatement, Expression expression) {
        OtherFunction otherFunction;
        ModelExpression modelExpression;
        RelationalExpression relationalExpression = expression.getLogicalExpression().getMultisetExpression().getRelationalExpression();
        if (relationalExpression.getCompoundExpression() != null && relationalExpression.getCompoundExpression().getFConcatenation() != null && relationalExpression.getCompoundExpression().getFConcatenation().getModelExpression() != null && (modelExpression = relationalExpression.getCompoundExpression().getFConcatenation().getModelExpression()).getUnaryExpression() != null && modelExpression.getUnaryExpression().getStandardFunction() != null && modelExpression.getUnaryExpression().getStandardFunction().getOtherFunction() != null && (otherFunction = modelExpression.getUnaryExpression().getStandardFunction().getOtherFunction()).getKeyWordName() != null && otherFunction.getKeyWordName().equalsIgnoreCase("SQL") && otherFunction.getCursorNameValue() != null && otherFunction.getCursorNameValue().equalsIgnoreCase("%ROWCOUNT")) {
            assignmentStatement.setExistSqlRowCount(true);
        }
    }
}

