/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Body;
import com.huawei.hwclouds.migration.oracle.model.ExceptionHandler;
import com.huawei.hwclouds.migration.oracle.model.SeqOfStatement;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Body.class)
public class BodyUnParser
implements UnParser<Body> {
    @Override
    public void unParse(Body sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        writer.append("BEGIN").newLine();
        for (int i = 0; i < sqlNode.getSeqOfStatementSqlNodeList().getNodes().size(); ++i) {
            sqlNode.getSeqOfStatementSqlNodeList().getNodes().get(i).unParse(writer, context);
        }
        if (sqlNode.getExceptionHandler() != null) {
            boolean allTransactionControl = BodyUnParser.isAllTransactionControl(sqlNode.getExceptionHandler().getNodes());
            if (allTransactionControl || ConfigUtil.getConfigValue(config, "table.plsql.exception", "true").equalsIgnoreCase("true")) {
                writer.append("/* ");
                writer.append("EXCEPTION ");
                for (int i = 0; i < sqlNode.getExceptionHandler().getNodes().size(); ++i) {
                    sqlNode.getExceptionHandler().getNodes().get(i).unParse(writer, context);
                }
                writer.append(" */ ");
            } else {
                writer.append("EXCEPTION ");
                for (ExceptionHandler exceptionHandler : sqlNode.getExceptionHandler().getNodes()) {
                    if (BodyUnParser.isAllTransactionControl(exceptionHandler)) {
                        writer.append("/* ");
                        exceptionHandler.unParse(writer, context);
                        writer.append(" */ ");
                        continue;
                    }
                    exceptionHandler.unParse(writer, context);
                }
            }
        }
        writer.append("END;").newLine().append("/SIGN_DSC_FORMAT_001");
    }

    private static boolean isAllTransactionControl(List<ExceptionHandler> exceptionhandlerList) {
        for (ExceptionHandler exceptionHandler : exceptionhandlerList) {
            if (BodyUnParser.isAllTransactionControl(exceptionHandler)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllTransactionControl(ExceptionHandler exceptionhandler) {
        boolean allTransactionControl = true;
        for (SeqOfStatement seqOfStatement : exceptionhandler.getSeqOfStatementSqlNodeList().getNodes()) {
            if (seqOfStatement.getStatement() != null && seqOfStatement.getStatement().getSqlStatement() != null && seqOfStatement.getStatement().getSqlStatement().getTransactionControlStatements() != null) continue;
            allTransactionControl = false;
            break;
        }
        return allTransactionControl;
    }
}

