/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.CreateFunctionBody;
import com.huawei.hwclouds.migration.oracle.model.Parameter;
import com.huawei.hwclouds.migration.oracle.model.SqlTypeName;
import com.huawei.hwclouds.migration.oracle.model.TypeSpec;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateFunctionBody.class)
public class CreateFunctionBodyUnParser
implements UnParser<CreateFunctionBody> {
    @Override
    public void unParse(CreateFunctionBody sqlNode, SqlWriter writer, UnParserContext context) {
        int i;
        this.handleExceptionHandler(sqlNode, writer);
        writer.append("CREATE ");
        if (sqlNode.isExistReplace()) {
            writer.append("OR REPLACE ");
        }
        writer.append("FUNCTION ").append(sqlNode.getFunctionName()).writeSpace(1);
        if (sqlNode.getParameterSqlNodeList() != null) {
            writer.append("( ");
            for (i = 0; i < sqlNode.getParameterSqlNodeList().getNodes().size(); ++i) {
                sqlNode.getParameterSqlNodeList().getNodes().get(i).unParse(writer, context);
                if (i == sqlNode.getParameterSqlNodeList().getNodes().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
        writer.append("RETURN ");
        if ("PIPELINED".equals(sqlNode.getFunctionType())) {
            writer.append("SETOF").writeSpace();
        }
        sqlNode.getTypeSpec().unParse(writer, context);
        writer.writeSpace(1);
        if (sqlNode.getFunctionSubOptionClause() != null) {
            for (i = 0; i < sqlNode.getFunctionSubOptionClause().getNodes().size(); ++i) {
                sqlNode.getFunctionSubOptionClause().unParse(writer, context);
            }
        }
        if (sqlNode.getImplementationTypeName() != null) {
            writer.append(sqlNode.getFunctionType()).writeSpace(1).append("USING ").append(sqlNode.getImplementationTypeName()).writeSpace(1);
        } else {
            writer.append(sqlNode.getIsOrAs()).writeSpace(1);
            if (sqlNode.getSeqOfDeclareSpecs() != null) {
                writer.append("DECLARE ");
                sqlNode.getSeqOfDeclareSpecs().unParse(writer, context);
            }
            if (sqlNode.getBody() != null) {
                context.setSubTransactionInplsql(true);
                sqlNode.getBody().unParse(writer, context);
            }
            if (sqlNode.getCallSpec() != null) {
                sqlNode.getCallSpec().unParse(writer, context);
            }
        }
        context.setExceptionHandler(false);
    }

    private void handleExceptionHandler(CreateFunctionBody sqlNode, SqlWriter writer) {
        String exceptionHandlers = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.exception.handler", "").toLowerCase(Locale.ROOT).replace(" ", "");
        if (exceptionHandlers.isEmpty()) {
            return;
        }
        List<String> handlerNameList = Arrays.asList(exceptionHandlers.split(","));
        if (handlerNameList.contains(sqlNode.getFunctionName().toLowerCase(Locale.ROOT))) {
            if (sqlNode.getParameterSqlNodeList() == null) {
                sqlNode.setParameterSqlNodeList(new SqlNodeList<Parameter>());
            }
            List<Parameter> parameterDeclaration = sqlNode.getParameterSqlNodeList().getNodes();
            CreateFunctionBodyUnParser.setExceptionParameter(parameterDeclaration);
        }
    }

    public static void setExceptionParameter(List<Parameter> parameterDeclaration) {
        Parameter contextParameter = new Parameter();
        contextParameter.setParameterName("p_exception_context");
        contextParameter.setTypeSpec(TypeSpec.initType(SqlTypeName.TEXT));
        parameterDeclaration.add(contextParameter);
        Parameter sqlstateParameter = new Parameter();
        sqlstateParameter.setParameterName("p_sqlstate");
        sqlstateParameter.setTypeSpec(TypeSpec.initType(SqlTypeName.VARCHAR));
        parameterDeclaration.add(sqlstateParameter);
        Parameter sqlerrmParameter = new Parameter();
        sqlerrmParameter.setParameterName("p_sqlerrm");
        sqlerrmParameter.setTypeSpec(TypeSpec.initType(SqlTypeName.VARCHAR));
        parameterDeclaration.add(sqlerrmParameter);
    }
}

