/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.CreatePackageBody;
import com.huawei.hwclouds.migration.oracle.model.DeclareSpec;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreatePackageBody.class)
public class CreatePackageBodyUnParser
implements UnParser<CreatePackageBody> {
    @Override
    public void unParse(CreatePackageBody sqlNode, SqlWriter writer, UnParserContext context) {
        context.setPackageName(sqlNode.getPackageName());
        for (int i = 0; i < sqlNode.getPackageObjBodySqlNodeList().getNodes().size(); ++i) {
            DeclareSpec declareSpec = sqlNode.getPackageObjBodySqlNodeList().getNodes().get(i);
            if (declareSpec.getProcedureBody() != null) {
                writer.append("CREATE ");
                if (sqlNode.isExistReplace()) {
                    writer.append("OR REPLACE ");
                }
                writer.append(this.getPackagePartType(declareSpec)).writeSpace();
            }
            this.unParsePackageBody(sqlNode, declareSpec, writer, context);
        }
        context.setNeedDivision(false);
        context.setPackageName(null);
    }

    private String getPackagePartType(DeclareSpec node) {
        if (node.getProcedureBody() != null) {
            return "PROCEDURE";
        }
        if (node.getFunctionBody() != null) {
            return "FUNCTION";
        }
        return null;
    }

    private void unParsePackageBody(CreatePackageBody packageBody, DeclareSpec sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getProcedureBody() != null) {
            writer.append(packageBody.getPackageName().toLowerCase(Locale.ROOT)).append("_");
            sqlNode.getProcedureBody().unParse(writer, context);
        } else if (sqlNode.getFunctionBody() != null) {
            sqlNode.getFunctionBody().getCreateFunctionBody().setFunctionName(packageBody.getPackageName().toLowerCase(Locale.ROOT) + "_" + sqlNode.getFunctionBody().getCreateFunctionBody().getFunctionName());
            sqlNode.getFunctionBody().unParse(writer, context);
        }
    }
}

