/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.config.PackageInfo;
import com.huawei.hwclouds.migration.oracle.config.PackageTypeEnum;
import com.huawei.hwclouds.migration.oracle.model.CreatePackage;
import com.huawei.hwclouds.migration.oracle.model.DeclareSpec;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreatePackage.class)
public class CreatePackageUnParser
implements UnParser<CreatePackage> {
    @Override
    public void unParse(CreatePackage sqlNode, SqlWriter writer, UnParserContext context) {
        this.getVariableMapper(sqlNode, writer, context);
    }

    private void getVariableMapper(CreatePackage sqlNode, SqlWriter writer, UnParserContext context) {
        PackageInfo packageInfo = new PackageInfo();
        String packageName = sqlNode.getPackageName();
        packageInfo.setPkgName(packageName);
        context.setPackageInfo(packageInfo);
        List<DeclareSpec> nodes = sqlNode.getPackageObjSpec().getNodes();
        for (DeclareSpec node : nodes) {
            SqlWriter newWriter;
            String identifier;
            if (node.getVariableDeclaration() != null) {
                identifier = node.getVariableDeclaration().getIdentifier().toUpperCase(Locale.ROOT);
                newWriter = writer.cloneEmpty();
                node.getVariableDeclaration().unParse(newWriter, context);
                packageInfo.getTypeMap().put(identifier, PackageTypeEnum.CONSTANT.name());
                packageInfo.getOutputMap().put(identifier, newWriter.toSqlString().toString());
                continue;
            }
            if (node.getTypeDeclaration() == null) continue;
            identifier = node.getTypeDeclaration().getIdentifier().toUpperCase(Locale.ROOT);
            if (node.getTypeDeclaration().getRefCursorTypeDef() != null) {
                packageInfo.getTypeMap().put(identifier, PackageTypeEnum.CURSOR.name());
                continue;
            }
            if (node.getTypeDeclaration().getRecordTypeDef() != null) {
                packageInfo.getTypeMap().put(identifier, PackageTypeEnum.RECORD.name());
                writer.append("CREATE TYPE ").append(packageName).append("_").append(identifier).writeSpace().append("AS(");
                node.getTypeDeclaration().getRecordTypeDef().unParse(writer, context);
                writer.append(")").sqlEnd();
                continue;
            }
            if (node.getTypeDeclaration().getTableTypeDef() != null) {
                if (node.getTypeDeclaration().getTableTypeDef().getTableIndexedByPart() != null) {
                    packageInfo.getTypeMap().put(identifier, PackageTypeEnum.TABLE_LIST.name());
                    continue;
                }
                packageInfo.getTypeMap().put(identifier, PackageTypeEnum.TABLE.name());
                packageInfo.getOutputMap().put(identifier, node.getTypeDeclaration().getTableTypeDef().getTypeSpec().getTypeName());
                continue;
            }
            packageInfo.getTypeMap().put(identifier, PackageTypeEnum.TYPE.name());
            newWriter = writer.cloneEmpty();
            node.getTypeDeclaration().unParse(newWriter, context);
            packageInfo.getOutputMap().put(identifier, newWriter.toSqlString().toString());
        }
    }
}

