/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.CreateSchema;
import com.huawei.hwclouds.migration.oracle.model.CreateSchemaDetail;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateSchema.class)
public class CreateSchemaUnParser
implements UnParser<CreateSchema> {
    @Override
    public void unParse(CreateSchema sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE SCHEMA").writeSpace(1);
        if (sqlNode.getSchemaName() != null) {
            writer.append(sqlNode.getSchemaName().getIdentifier()).writeSpace(1);
        }
        if (sqlNode.isAuthorization()) {
            writer.append("AUTHORIZATION").writeSpace(1);
        }
        if (sqlNode.getUserName() != null) {
            writer.append(sqlNode.getUserName().getIdentifier());
        }
        List<CreateSchemaDetail> schemaDetails = sqlNode.getSchemaDetails();
        for (int i = 0; i < schemaDetails.size(); ++i) {
            writer.writeSpace(1);
            CreateSchemaDetail schemaDetail = schemaDetails.get(i);
            if (schemaDetail.getCreateTable() != null) {
                schemaDetail.getCreateTable().unParse(writer, context);
                continue;
            }
            if (schemaDetail.getCreateView() != null) {
                schemaDetail.getCreateView().unParse(writer, context);
                continue;
            }
            schemaDetail.getGrant().unParse(writer, context);
        }
    }
}

