/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.DmlTableExpressionClause;
import com.huawei.hwclouds.migration.oracle.model.SubQueryRestrictionClause;
import com.huawei.hwclouds.migration.oracle.model.TableCollectionExpression;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=DmlTableExpressionClause.class)
public class DmlTableExpressionClauseUnParser
implements UnParser<DmlTableExpressionClause> {
    @Override
    public void unParse(DmlTableExpressionClause sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getCollectionExpression() != null) {
            this.dealDmlTableExpTableCollection(sqlNode.getCollectionExpression(), writer, context);
        }
        if (sqlNode.getSubQuery() != null) {
            this.dealDmlTableExpSubQuery(sqlNode, writer, context);
        }
        if (sqlNode.getTableName() != null) {
            this.dealDmlTableExpTableViewName(sqlNode, writer, context);
        }
    }

    private void dealDmlTableExpTableCollection(TableCollectionExpression collectionExpression, SqlWriter writer, UnParserContext context) {
        writer.writeSpace(1).append(collectionExpression.getTableOrThe()).append(" ( ");
        if (collectionExpression.getSubQuery() != null) {
            collectionExpression.getSubQuery().unParse(writer, context);
        } else {
            collectionExpression.getExpression().unParse(writer, context);
        }
        writer.append(" ) ");
        if (collectionExpression.getOuterJoinSign() != null) {
            writer.append(collectionExpression.getOuterJoinSign());
        }
    }

    private void dealDmlTableExpSubQuery(DmlTableExpressionClause sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isLateral()) {
            writer.append(" LATERAL ");
        }
        sqlNode.getSubQuery().unParse(writer, context);
        if (sqlNode.getRestrictionClause() != null) {
            SubQueryRestrictionClause restrictionClause = sqlNode.getRestrictionClause();
            writer.append(" WITH ");
            if (restrictionClause.isReadOnly()) {
                writer.append("READ ONLY ");
            }
            if (restrictionClause.isCheckOption()) {
                writer.append("CHECK OPTION ");
            }
            if (restrictionClause.getConstraintName() != null) {
                writer.append("CONSTRAINT ").append(restrictionClause.getConstraintName());
            }
        }
    }

    private void dealDmlTableExpTableViewName(DmlTableExpressionClause sqlNode, SqlWriter writer, UnParserContext context) {
        sqlNode.getTableName().unParse(writer, context);
        if (sqlNode.getSampleClause() != null) {
            sqlNode.getSampleClause().unParse(writer, context);
        }
    }
}

