/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.ExceptionHandler;
import com.huawei.hwclouds.migration.oracle.model.SeqOfStatement;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=ExceptionHandler.class)
public class ExceptionHandlerUnParser
implements UnParser<ExceptionHandler> {
    @Override
    public void unParse(ExceptionHandler sqlNode, SqlWriter writer, UnParserContext context) {
        context.setException(true);
        writer.append("WHEN ");
        for (int i = 0; i < sqlNode.getExceptionNameList().size(); ++i) {
            writer.append(sqlNode.getExceptionNameList().get(i)).writeSpace(1);
            if (i == 0) continue;
            writer.append("OR ").append(sqlNode.getExceptionNameList().get(i)).writeSpace(1);
        }
        writer.append("THEN ");
        boolean getDiagnosticsExisted = false;
        for (int i = 0; i < sqlNode.getSeqOfStatementSqlNodeList().getNodes().size(); ++i) {
            SeqOfStatement seqOfStatement = sqlNode.getSeqOfStatementSqlNodeList().getNodes().get(i);
            if (seqOfStatement.getStatement() != null && seqOfStatement.getStatement().getFunctionCall() != null && !getDiagnosticsExisted) {
                writer.newLine().append("GET DIAGNOSTICS").newLine();
                writer.append("v_exception_context = PG_EXCEPTION_CONTEXT;").newLine();
                writer.append("v_sqlstate = SQLSTATE;").newLine();
                writer.append("v_sqlerrm = SQLERRM;").newLine();
                getDiagnosticsExisted = true;
            }
            seqOfStatement.unParse(writer, context);
        }
        context.setException(false);
    }
}

