/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.LogicalExpression;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Expression.class)
public class ExpressionUnParser
implements UnParser<Expression> {
    @Override
    public void unParse(Expression sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getLogicalExpression() != null) {
            LogicalExpression logicalExpression = sqlNode.getLogicalExpression();
            if (logicalExpression.getFLogicalExpression() != null) {
                logicalExpression.getFLogicalExpression().unParse(writer, context);
                if (context.getSelectListChildCount() == 0 || !context.isScalarInWhereClause()) {
                    writer.append(logicalExpression.getOperator().toUpperCase(Locale.ROOT)).writeSpace(1);
                }
                logicalExpression.getSLogicalExpression().unParse(writer, context);
            } else {
                if (logicalExpression.isExistNot()) {
                    writer.append("NOT").writeSpace(1);
                }
                logicalExpression.getMultisetExpression().unParse(writer, context);
                if (sqlNode.getLogicalExpression().getLogicalOperationList() != null) {
                    for (int i = 0; i < logicalExpression.getLogicalOperationList().size(); ++i) {
                        logicalExpression.getLogicalOperationList().get(i).unParse(writer, context);
                    }
                }
            }
        } else if (sqlNode.getCursorExpression() != null) {
            writer.append("CURSOR (").writeSpace(1);
            sqlNode.getCursorExpression().unParse(writer, context);
            writer.append(")").writeSpace(1);
        }
    }
}

