/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.FetchStatement;
import com.huawei.hwclouds.migration.oracle.model.VariableName;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FetchStatement.class)
public class FetchStatementUnParser
implements UnParser<FetchStatement> {
    private static final String RESOURCE_NAME = "_bulk_resource";

    @Override
    public void unParse(FetchStatement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isBulkCollect()) {
            VariableName variableName;
            int i;
            writer.append("LOOP").newLine();
            writer.append("EXIT WHEN");
            sqlNode.getCursorName().unParse(writer, context);
            writer.append("%NOTFOUND").sqlEnd().newLine();
            writer.append("FETCH").writeSpace();
            sqlNode.getCursorName().unParse(writer, context);
            writer.writeSpace().append("INTO").writeSpace();
            List<VariableName> variableNameList = sqlNode.getVariableNameSqlNodeList().getNodes();
            for (i = 0; i < variableNameList.size(); ++i) {
                variableName = variableNameList.get(i);
                variableName.unParse(writer, context);
                writer.append(RESOURCE_NAME);
                if (i >= variableNameList.size() - 1) continue;
                writer.append(", ");
            }
            writer.sqlEnd().newLine();
            for (i = 0; i < variableNameList.size(); ++i) {
                variableName = variableNameList.get(i);
                variableName.unParse(writer, context);
                writer.writeSpace().append(":=").writeSpace().append("array_append(");
                variableName.unParse(writer, context);
                writer.append(",");
                variableName.unParse(writer, context);
                writer.append(RESOURCE_NAME).append(")");
                writer.sqlEnd().newLine();
            }
            writer.append("END LOOP");
        } else {
            writer.append("FETCH").writeSpace();
            sqlNode.getCursorName().unParse(writer, context);
            writer.writeSpace().append("INTO").writeSpace();
            sqlNode.getVariableNameSqlNodeList().unParse(writer, context);
        }
    }
}

