/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.AdvancedPackage;
import com.huawei.hwclouds.migration.oracle.model.Argument;
import com.huawei.hwclouds.migration.oracle.model.Constant;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.FunctionArgument;
import com.huawei.hwclouds.migration.oracle.model.FunctionCall;
import com.huawei.hwclouds.migration.oracle.util.GetArgumentUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FunctionCall.class)
public class FunctionCallUnParser
implements UnParser<FunctionCall> {
    private static final List<String> IGNORE_LIST = Arrays.asList("dbms_application_info.set_client_info");

    @Override
    public void unParse(FunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        if (this.dealWithFunction(sqlNode, writer, context)) {
            return;
        }
        if (!this.needCall(sqlNode.getRoutineName())) {
            if (sqlNode.isExistCall()) {
                writer.append("CALL ");
            }
        } else {
            if (sqlNode.isExistCall() || context.isProcedure() && !context.isException()) {
                writer.append("CALL ");
            }
            if (context.isException()) {
                writer.append("PERFORM ");
            }
        }
        writer.append(sqlNode.getRoutineName());
        if (sqlNode.isExistsBrackets()) {
            writer.append("( ");
            if (sqlNode.getFunctionArgument() != null) {
                sqlNode.getFunctionArgument().unParse(writer, context);
            }
            if (context.isException()) {
                if (sqlNode.getFunctionArgument() != null) {
                    writer.append(", ");
                }
                writer.append("v_exception_context, v_sqlstate, v_sqlerrm");
            }
            writer.append(") ");
            if (sqlNode.getKeepClause() != null) {
                sqlNode.getKeepClause().unParse(writer, context);
            }
        }
    }

    private boolean needCall(String routineName) {
        String[] parts = routineName.split("\\.");
        return Arrays.stream(AdvancedPackage.values()).noneMatch(advancedPackage -> advancedPackage.name().equalsIgnoreCase(parts[0]));
    }

    private boolean dealWithFunction(FunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        String lowerCase = sqlNode.getRoutineName().toLowerCase(Locale.ROOT);
        if (IGNORE_LIST.contains(lowerCase)) {
            sqlNode.setSkipSemicolon(true);
            return true;
        }
        if (lowerCase.contains(".extend")) {
            if (sqlNode.getFunctionArgument() == null) {
                Constant constant = new Constant();
                constant.setNumeric("1");
                Argument argument = GetArgumentUtil.extracted(constant);
                FunctionArgument functionArgument = new FunctionArgument();
                ArrayList<Argument> argumentList = new ArrayList<Argument>();
                argumentList.add(argument);
                functionArgument.setArgumentList(argumentList);
                sqlNode.setFunctionArgument(functionArgument);
            }
        } else {
            if (lowerCase.equalsIgnoreCase("dbms_utility.exec_ddl_statement")) {
                writer.append("EXECUTE IMMEDIATE ");
                sqlNode.getFunctionArgument().unParse(writer, context);
                return true;
            }
            if (lowerCase.equalsIgnoreCase("dbms_lock.sleep")) {
                writer.append("select pg_sleep(");
                sqlNode.getFunctionArgument().unParse(writer, context);
                writer.append(")");
                return true;
            }
            if (lowerCase.equalsIgnoreCase("dbms_stats.set_table_stats")) {
                if (sqlNode.getFunctionArgument() != null && sqlNode.getFunctionArgument().getArgumentList() != null && sqlNode.getFunctionArgument().getArgumentList().size() >= 2) {
                    Expression schemaExpression = sqlNode.getFunctionArgument().getArgumentList().get(0).getExpression();
                    Expression tableExpression = sqlNode.getFunctionArgument().getArgumentList().get(1).getExpression();
                    if (schemaExpression != null && tableExpression != null && schemaExpression.getConstant() != null && schemaExpression.getConstant().getQuotedString() != null && tableExpression.getConstant() != null && tableExpression.getConstant().getQuotedString() != null) {
                        writer.append("analyze").writeSpace();
                        writer.append(schemaExpression.getConstant().getQuotedString().replace("'", "")).append(".");
                        writer.append(tableExpression.getConstant().getQuotedString().replace("'", ""));
                    }
                } else {
                    sqlNode.setSkipSemicolon(true);
                }
                return true;
            }
        }
        return false;
    }
}

