/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.GroupByClause;
import com.huawei.hwclouds.migration.oracle.model.GroupByElement;
import com.huawei.hwclouds.migration.oracle.model.HavingClause;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=GroupByClause.class)
public class GroupByClauseUnParser
implements UnParser<GroupByClause> {
    @Override
    public void unParse(GroupByClause sqlNode, SqlWriter writer, UnParserContext context) {
        HavingClause havingClause;
        List<GroupByElement> groupByElements = sqlNode.getGroupByElements().getNodes();
        if (groupByElements != null && groupByElements.size() > 0) {
            writer.append(" GROUP BY ");
            for (int i = 0; i < groupByElements.size(); ++i) {
                groupByElements.get(i).unParse(writer, context);
                if (i == groupByElements.size() - 1) continue;
                writer.append(", ");
            }
        }
        if ((havingClause = sqlNode.getHavingClause()) != null) {
            writer.append(" HAVING ");
            if (havingClause.getExpression() != null) {
                havingClause.getExpression().unParse(writer, context);
            }
            if (havingClause.getJsonCondition() != null) {
                havingClause.getJsonCondition().unParse(writer, context);
            }
        }
    }
}

