/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Identifier.class)
public class IdentifierUnParser
implements UnParser<Identifier> {
    @Override
    public void unParse(Identifier sqlNode, SqlWriter writer, UnParserContext context) {
        String identifier = sqlNode.getIdentifier().trim();
        identifier = QuoteUtils.removeDoubleQuote(identifier);
        ConvertConfig configForCase = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(configForCase, "table.create.inSensitive", "true").equalsIgnoreCase("true")) {
            writer.append(QuoteUtils.addDoubleQuote(identifier.toLowerCase(Locale.US)));
        } else {
            writer.append(QuoteUtils.addDoubleQuote(identifier));
        }
    }
}

