/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.JoinClause;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=JoinClause.class)
public class JoinClauseUnParser
implements UnParser<JoinClause> {
    @Override
    public void unParse(JoinClause sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getQueryPartitionClause() != null) {
            sqlNode.getQueryPartitionClause().unParse(writer, context);
        }
        if (sqlNode.getJoinType() != null) {
            writer.writeSpace(1).append(sqlNode.getJoinType()).writeSpace(1);
        }
        writer.append(" JOIN ");
        sqlNode.getSqlTableRef().unParse(writer, context);
        if (sqlNode.getJoinQueryPartition() != null) {
            sqlNode.getJoinQueryPartition().unParse(writer, context);
        }
        this.dealWithJoinParts(sqlNode, writer, context);
    }

    private void dealWithJoinParts(JoinClause sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getJoinOnPart() != null) {
            writer.append(" ON ");
            sqlNode.getJoinOnPart().getExpression().unParse(writer, context);
        }
        if (sqlNode.getJoinUsingPart() != null) {
            List<Identifier> columns = sqlNode.getJoinUsingPart().getNodes();
            writer.append(" USING (");
            for (int i = 0; i < columns.size(); ++i) {
                writer.append(columns.get(i).getIdentifier());
                if (i == columns.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(")");
        }
    }
}

