/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.SqlLiteral;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SqlLiteral.class)
public class LiteralUnParser
implements UnParser<SqlLiteral> {
    @Override
    public void unParse(SqlLiteral sqlNode, SqlWriter writer, UnParserContext context) {
        switch (sqlNode.getType()) {
            case BOOLEAN: {
                writer.append(LiteralUnParser.createBoolean((Boolean)sqlNode.getValue()));
                return;
            }
            case INTEGER: 
            case DECIMAL: 
            case INT: 
            case ANY: {
                if (sqlNode.getValue().toString().equalsIgnoreCase("'CURRENT_TIMESTAMP'")) {
                    writer.append(LiteralUnParser.createNumeric(QuoteUtils.removeAllQuoteForField(sqlNode.getValue().toString()))).writeSpace(1);
                } else {
                    writer.append(LiteralUnParser.createNumeric(sqlNode.getValue().toString())).writeSpace(1);
                }
                return;
            }
            case VARCHAR: 
            case CHAR: {
                writer.append(QuoteUtils.addSingleQuote(QuoteUtils.removeAllQuoteForField(sqlNode.getValue().toString()))).writeSpace(1);
                return;
            }
        }
        throw new ParserRuntimeException("Other types are not supported in DSC");
    }

    public static String createBoolean(boolean valueTrueOrFalse) {
        return valueTrueOrFalse ? "1" : "0";
    }

    public static String createNumeric(String str) {
        return str;
    }

    public static String createText(String str) {
        return str;
    }
}

