/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.ExpressionAlias;
import com.huawei.hwclouds.migration.oracle.model.ModelColumnClauses;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=ModelColumnClauses.class)
public class ModelColumnClausesUnParser
implements UnParser<ModelColumnClauses> {
    @Override
    public void unParse(ModelColumnClauses sqlNode, SqlWriter writer, UnParserContext context) {
        List<ExpressionAlias> measuresList;
        List<ExpressionAlias> dimensionList;
        List<ExpressionAlias> partitionList = sqlNode.getPartitionByInfos().getNodes();
        if (partitionList != null && partitionList.size() > 0) {
            writer.append(" PARTITION BY (");
            this.dealWithSqlExpressionAlias(partitionList, writer, context);
            writer.append(")");
        }
        if ((dimensionList = sqlNode.getDimensionByInfos().getNodes()) != null && dimensionList.size() > 0) {
            writer.append(" DIMENSION BY (");
            this.dealWithSqlExpressionAlias(dimensionList, writer, context);
            writer.append(")");
        }
        if ((measuresList = sqlNode.getMeasuresInfos().getNodes()) != null && measuresList.size() > 0) {
            writer.append(" MEASURES (");
            this.dealWithSqlExpressionAlias(measuresList, writer, context);
            writer.append(")");
        }
    }

    private void dealWithSqlExpressionAlias(List<ExpressionAlias> aliases, SqlWriter writer, UnParserContext context) {
        for (int i = 0; i < aliases.size(); ++i) {
            ExpressionAlias expressionAlias = aliases.get(i);
            if (expressionAlias.getExpression() != null) {
                expressionAlias.getExpression().unParse(writer, context);
            }
            if (expressionAlias.getQueryBlock() != null) {
                expressionAlias.getQueryBlock().unParse(writer, context);
            }
            if (expressionAlias.getAlias() == null) continue;
            writer.writeSpace(1).append(expressionAlias.getAlias().getIdentifier()).writeSpace(1);
        }
    }
}

