/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.MultiTableElement;
import com.huawei.hwclouds.migration.oracle.model.MultiTableInsert;
import com.huawei.hwclouds.migration.oracle.model.QueryBlock;
import com.huawei.hwclouds.migration.oracle.model.SelectListElement;
import com.huawei.hwclouds.migration.oracle.model.SelectOnlyStatement;
import com.huawei.hwclouds.migration.oracle.model.SelectStatement;
import com.huawei.hwclouds.migration.oracle.model.SubQuery;
import com.huawei.hwclouds.migration.oracle.model.SubQueryBasicElement;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Optional;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=MultiTableInsert.class)
public class MultiTableInsertUnParser
implements UnParser<MultiTableInsert> {
    @Override
    public void unParse(MultiTableInsert sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getConditionalInsertClause() != null) {
            sqlNode.getConditionalInsertClause().unParse(writer, context);
        } else {
            List<MultiTableElement> elementList = sqlNode.getMultiTableElementList().getNodes();
            if (elementList == null || elementList.isEmpty()) {
                return;
            }
            QueryBlock queryBlock = Optional.ofNullable(sqlNode.getSelectStatement()).map(SelectStatement::getSelectOnlyStatement).map(SelectOnlyStatement::getSubQuery).map(SubQuery::getSubQueryBasicElement).map(SubQueryBasicElement::getQueryBlock).orElse(null);
            if (queryBlock != null && queryBlock.isStar()) {
                queryBlock.setStar(false);
                SqlNodeList<SelectListElement> selectListElements = new SqlNodeList<SelectListElement>();
                elementList.get(0).getValuesClause().getExpressionList().forEach(expression -> {
                    SelectListElement selectListElement = new SelectListElement();
                    selectListElement.setExpression((Expression)expression);
                    selectListElements.addNode(selectListElement);
                });
                queryBlock.setSelectListElements(selectListElements);
            }
            for (int i = 0; i < elementList.size(); ++i) {
                writer.append("INSERT ");
                elementList.get(i).getInsertIntoClause().unParse(writer, context);
                sqlNode.getSelectStatement().unParse(writer, context);
                if (i >= elementList.size() - 1) continue;
                writer.sqlEnd().newLine();
            }
        }
    }
}

