/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.ArgumentWithRes;
import com.huawei.hwclouds.migration.oracle.model.OtherFunction;
import com.huawei.hwclouds.migration.oracle.unparser.StandardFunctionUnParser;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=OtherFunction.class)
public class OtherFunctionUnParser
implements UnParser<OtherFunction> {
    @Override
    public void unParse(OtherFunction sqlNode, SqlWriter writer, UnParserContext context) {
        sqlNode.setFunctionName(StandardFunctionUnParser.convertFunctionName(sqlNode.getFunctionName(), writer));
        if (sqlNode.getFunctionName() != null) {
            switch (sqlNode.getFunctionName().toLowerCase(Locale.ROOT)) {
                case "count": {
                    writer.append("COUNT(").append(sqlNode.getCountValue()).writeSpace(1);
                    if (sqlNode.getConcatenation() != null) {
                        sqlNode.getConcatenation().unParse(writer, context);
                    }
                    writer.append(") ");
                    if (sqlNode.getOverClause() == null) break;
                    sqlNode.getOverClause().unParse(writer, context);
                    break;
                }
                case "cast": 
                case "xmlcast": 
                case "collect": {
                    throw new ParserRuntimeException("The function " + sqlNode.getFunctionName() + " is not support");
                }
                case "extract": {
                    writer.append("EXTRACT(").append(sqlNode.getKeyWordName()).append(" FROM ");
                    sqlNode.getConcatenation().unParse(writer, context);
                    writer.append(")");
                    break;
                }
            }
        } else if (sqlNode.getKeyWordName() != null) {
            this.dealWithOverClause(sqlNode, writer, context);
        } else {
            writer.append(sqlNode.getKeyWordName()).writeSpace(1);
            if (sqlNode.getCursorNameValue() != null) {
                writer.append(sqlNode.getCursorNameValue()).writeSpace(1);
            }
        }
    }

    private void dealWithOverClause(OtherFunction sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(sqlNode.getKeyWordName());
        if (sqlNode.getFunctionArgumentAnalytic() != null) {
            writer.append("( ");
            List<ArgumentWithRes> nodes = sqlNode.getFunctionArgumentAnalytic().getArgumentWithResSqlNodeList().getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).unParse(writer, context);
                if (i == nodes.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
            if (sqlNode.getFunctionArgumentAnalytic().getKeepClause() != null) {
                sqlNode.getFunctionArgumentAnalytic().getKeepClause().unParse(writer, context);
            }
        }
        if (sqlNode.getOverClause() != null) {
            sqlNode.getOverClause().unParse(writer, context);
        }
        if (sqlNode.getCursorNameValue() != null) {
            writer.append(sqlNode.getCursorNameValue());
        }
    }
}

