/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.HashPartitionsByQuantity;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.Literal;
import com.huawei.hwclouds.migration.oracle.model.PartitionDefinition;
import com.huawei.hwclouds.migration.oracle.model.TablePartitioningClauses;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.util.SqlWriteUtil;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TablePartitioningClauses.class)
public class PartitionDefinitionsUnParser
implements UnParser<TablePartitioningClauses> {
    @Override
    public void unParse(TablePartitioningClauses sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isOther()) {
            this.alterPartitionUsed(sqlNode, writer, context);
        } else {
            this.createPartitionUsed(sqlNode, writer, context);
        }
    }

    private void alterPartitionUsed(TablePartitioningClauses sqlNode, SqlWriter writer, UnParserContext context) {
        List<PartitionDefinition> partitionDefinition = sqlNode.getPartitionDefinition().getNodes();
        for (int i = 0; i < partitionDefinition.size(); ++i) {
            this.spellPartitionDefinition(partitionDefinition.get(i), writer, sqlNode.getPartitionFunction(), context);
            if (i == partitionDefinition.size() - 1) continue;
            writer.append(",");
        }
    }

    private void createPartitionUsed(TablePartitioningClauses sqlNode, SqlWriter writer, UnParserContext context) {
        TablePartitioningClauses.PartitionFunction partitionFunction = sqlNode.getPartitionFunction();
        if (partitionFunction != null) {
            writer.newLine();
            if (sqlNode.isInterval()) {
                writer.append(" /* ");
            }
            writer.append("PARTITION").writeSpace(1).append("BY").writeSpace(1);
            if (partitionFunction.equals((Object)TablePartitioningClauses.PartitionFunction.RANGE)) {
                writer.append("RANGE");
            } else if (partitionFunction.equals((Object)TablePartitioningClauses.PartitionFunction.LIST)) {
                writer.append("LIST");
            } else if (partitionFunction.equals((Object)TablePartitioningClauses.PartitionFunction.HASH)) {
                writer.append("HASH");
            }
            writer.writeSpace(1).append("(").writeSpace(1);
            List<Identifier> columnName = sqlNode.getColumnName().getNodes();
            for (int i = 0; i < columnName.size(); ++i) {
                String identifier = SqlWriteUtil.handleInsensitive(columnName.get(i).getIdentifier(), writer);
                writer.append(identifier);
                if (i == columnName.size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
            writer.append(")").newLine();
            if (partitionFunction.equals((Object)TablePartitioningClauses.PartitionFunction.HASH)) {
                writer.append("/* ");
                this.unParserHashPartition(sqlNode, writer);
                writer.append("*/ ");
            } else {
                this.dealWithIntervalClause(sqlNode, writer, context);
                this.dealWithPartitionDefinition(sqlNode, writer, context);
            }
            if (sqlNode.isInterval()) {
                writer.append(" */ ");
            }
        }
    }

    private void unParserHashPartition(TablePartitioningClauses sqlNode, SqlWriter writer) {
        if (sqlNode.getIndividualHashPartitions() != null) {
            writer.append("( ");
            for (int i = 0; i < sqlNode.getIndividualHashPartitions().getNodes().size(); ++i) {
                writer.append("PARTITION ");
                if (sqlNode.getIndividualHashPartitions().getNodes().get(i).getPartitionName() != null) {
                    writer.append(sqlNode.getIndividualHashPartitions().getNodes().get(i).getPartitionName()).writeSpace(1);
                }
                if (sqlNode.getIndividualHashPartitions().getNodes().get(i).getPartitioningStorageClause() != null) {
                    writer.append(sqlNode.getIndividualHashPartitions().getNodes().get(i).getPartitioningStorageClause()).writeSpace(1);
                }
                if (i == sqlNode.getIndividualHashPartitions().getNodes().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        } else {
            HashPartitionsByQuantity hashPartitionsByQuantity = sqlNode.getHashPartitionsByQuantity();
            writer.append("PARTITIONS ").append(hashPartitionsByQuantity.getHashPartitionQuantity()).writeSpace(1);
            if (hashPartitionsByQuantity.getTableSpaceList() != null) {
                this.spellTableSpaceList(writer, hashPartitionsByQuantity.getTableSpaceList());
            }
            if (hashPartitionsByQuantity.getCompression() != null) {
                writer.append(hashPartitionsByQuantity.getCompression()).writeSpace(1);
            }
            if (hashPartitionsByQuantity.getTableSpaceListForOverFlow() != null) {
                writer.append("OVERFLOW ");
                this.spellTableSpaceList(writer, hashPartitionsByQuantity.getTableSpaceListForOverFlow());
            }
        }
    }

    private void spellTableSpaceList(SqlWriter writer, List<String> tableSpaceListForOverFlow) {
        writer.append("STORE IN ");
        writer.append("( ");
        for (int i = 0; i < tableSpaceListForOverFlow.size(); ++i) {
            writer.append(tableSpaceListForOverFlow.get(i)).writeSpace(1);
            if (i == tableSpaceListForOverFlow.size() - 1) continue;
            writer.append(", ");
        }
        writer.append(") ");
    }

    private void dealWithIntervalClause(TablePartitioningClauses sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isInterval()) {
            writer.append("INTERVAL (");
            sqlNode.getIntervalExpression().unParse(writer, context);
            writer.append(")");
            List<String> storeInTableSpaces = sqlNode.getStoreInTableSpaces();
            if (storeInTableSpaces != null) {
                writer.append("STORE IN ( ");
                for (int i = 0; i < storeInTableSpaces.size(); ++i) {
                    writer.append(storeInTableSpaces.get(i));
                    if (i == storeInTableSpaces.size() - 1) continue;
                    writer.append(", ");
                }
                writer.append(" ) ");
            }
        }
    }

    private void dealWithPartitionDefinition(TablePartitioningClauses sqlNode, SqlWriter writer, UnParserContext context) {
        List<PartitionDefinition> partitionDefinition = sqlNode.getPartitionDefinition().getNodes();
        TablePartitioningClauses.PartitionFunction partitionFunction = sqlNode.getPartitionFunction();
        writer.append("(").newLine();
        for (int i = 0; i < partitionDefinition.size(); ++i) {
            this.spellPartitionDefinition(partitionDefinition.get(i), writer, partitionFunction, context);
            if (i != partitionDefinition.size() - 1) {
                writer.append(",");
            }
            writer.newLine();
        }
        writer.append(")");
    }

    private void spellPartitionDefinition(PartitionDefinition sqlNode, SqlWriter writer, TablePartitioningClauses.PartitionFunction partitionFunction, UnParserContext context) {
        writer.append("PARTITION").writeSpace(1);
        if (sqlNode.getUid() != null) {
            sqlNode.getUid().unParse(writer, context);
        }
        if (partitionFunction.equals((Object)TablePartitioningClauses.PartitionFunction.RANGE)) {
            writer.append("VALUES LESS THAN (").writeSpace(1);
        }
        if (partitionFunction.equals((Object)TablePartitioningClauses.PartitionFunction.LIST)) {
            writer.append("VALUES (").writeSpace(1);
        }
        List<Literal> literals = sqlNode.getExpressions().getNodes();
        for (int i = 0; i < literals.size(); ++i) {
            if (literals.get(i).getStringFunction() != null) {
                literals.get(i).getStringFunction().unParse(writer, context);
            } else if (literals.get(i).getSystemFunction() != null) {
                literals.get(i).getSystemFunction().unParse(writer, context);
            } else {
                writer.append(literals.get(i).getLiteral());
            }
            if (i == literals.size() - 1) continue;
            writer.append(",").writeSpace(1);
        }
        writer.append(")");
    }
}

