/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.oracle.DWSMigrationService;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Accessor;
import com.huawei.hwclouds.migration.oracle.model.BulkCollectDeclaration;
import com.huawei.hwclouds.migration.oracle.model.DeclareSpec;
import com.huawei.hwclouds.migration.oracle.model.FetchStatement;
import com.huawei.hwclouds.migration.oracle.model.Parameter;
import com.huawei.hwclouds.migration.oracle.model.PlsqlProcedureSource;
import com.huawei.hwclouds.migration.oracle.model.ProcedureSubOptionClause;
import com.huawei.hwclouds.migration.oracle.model.SeqOfStatement;
import com.huawei.hwclouds.migration.oracle.model.TypeDeclaration;
import com.huawei.hwclouds.migration.oracle.model.VariableDeclaration;
import com.huawei.hwclouds.migration.oracle.model.VariableName;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.unparser.CreateFunctionBodyUnParser;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=PlsqlProcedureSource.class)
public class PlsqlProcedureSourceUnParser
implements UnParser<PlsqlProcedureSource> {
    @Override
    public void unParse(PlsqlProcedureSource sqlNode, SqlWriter writer, UnParserContext context) {
        int i;
        this.handleExceptionHandler(sqlNode, writer, context);
        if (sqlNode.getSchemaName() != null) {
            writer.append(sqlNode.getSchemaName()).append(".");
        }
        writer.append(sqlNode.getProcedureName()).writeSpace(1);
        this.handleBulk(sqlNode);
        if (sqlNode.getParameterDeclaration() != null) {
            writer.append("( ");
            for (i = 0; i < sqlNode.getParameterDeclaration().getNodes().size(); ++i) {
                sqlNode.getParameterDeclaration().getNodes().get(i).unParse(writer, context);
                if (i == sqlNode.getParameterDeclaration().getNodes().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
        if (sqlNode.getSharingClause() != null) {
            writer.append(sqlNode.getSharingClause()).writeSpace(1);
        }
        for (i = 0; i < sqlNode.getProcedureSubOptionClause().getNodes().size(); ++i) {
            ProcedureSubOptionClause procedureSubOptionClause = sqlNode.getProcedureSubOptionClause().getNodes().get(i);
            if (procedureSubOptionClause.getInvokerRightsClause() != null) {
                writer.append(procedureSubOptionClause.getInvokerRightsClause()).writeSpace(1);
                continue;
            }
            if (procedureSubOptionClause.getDefaultCollationClause() != null) {
                writer.append(procedureSubOptionClause.getDefaultCollationClause()).writeSpace(1);
                continue;
            }
            writer.append("ACCESSIBLE BY (");
            for (int j = 0; j < procedureSubOptionClause.getAccessibleByClause().getNodes().size(); ++j) {
                Accessor accessor = procedureSubOptionClause.getAccessibleByClause().getNodes().get(j);
                if (accessor.getUnitKind() != null) {
                    writer.append(accessor.getUnitKind()).writeSpace(1);
                }
                if (accessor.getSchemaName() != null) {
                    writer.append(accessor.getSchemaName()).append(".");
                }
                if (accessor.getUnitName() != null) {
                    writer.append(accessor.getUnitName()).writeSpace(1);
                }
                if (j == procedureSubOptionClause.getAccessibleByClause().getNodes().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
        writer.append(sqlNode.getIsOrAs()).writeSpace(1);
        if (sqlNode.getBody() != null) {
            if (sqlNode.getSeqOfDeclareSpecs() != null) {
                writer.append("DECLARE ");
                sqlNode.getSeqOfDeclareSpecs().unParse(writer, context);
            }
            this.addPackageConstant(sqlNode.getSeqOfDeclareSpecs() != null, writer, context);
            if (sqlNode.getBulkCollectDeclarationList() != null && !sqlNode.getBulkCollectDeclarationList().isEmpty()) {
                for (BulkCollectDeclaration bulkCollectDeclaration : sqlNode.getBulkCollectDeclarationList()) {
                    bulkCollectDeclaration.unParse(writer, context);
                    writer.append(";").newLine();
                }
            }
            sqlNode.getBody().unParse(writer, context);
        } else if (sqlNode.getCallSpec() != null) {
            sqlNode.getCallSpec().unParse(writer, context);
        } else {
            writer.append("EXTERNAL ");
        }
    }

    private void handleBulk(PlsqlProcedureSource sqlNode) {
        if (sqlNode.getBody() == null || sqlNode.getBody().getSeqOfStatementSqlNodeList() == null || sqlNode.getBody().getSeqOfStatementSqlNodeList().getNodes() == null) {
            return;
        }
        List<SeqOfStatement> nodes = sqlNode.getBody().getSeqOfStatementSqlNodeList().getNodes();
        ArrayList<String> bulkCollectVariableNameList = new ArrayList<String>();
        for (SeqOfStatement node : nodes) {
            FetchStatement fetchStatement;
            if (node.getStatement() == null || node.getStatement().getSqlStatement() == null || node.getStatement().getSqlStatement().getCursorManipulationStatements() == null || node.getStatement().getSqlStatement().getCursorManipulationStatements().getFetchStatement() == null || !(fetchStatement = node.getStatement().getSqlStatement().getCursorManipulationStatements().getFetchStatement()).isBulkCollect()) continue;
            for (VariableName variableName : fetchStatement.getVariableNameSqlNodeList().getNodes()) {
                if (bulkCollectVariableNameList.contains(variableName.getText())) continue;
                bulkCollectVariableNameList.add(variableName.getText());
                this.findBulkCollectType(variableName, sqlNode);
            }
        }
    }

    private void findBulkCollectType(VariableName variableName, PlsqlProcedureSource sqlNode) {
        if (sqlNode.getBulkCollectDeclarationList() == null) {
            sqlNode.setBulkCollectDeclarationList(new ArrayList<BulkCollectDeclaration>());
        }
        List<BulkCollectDeclaration> bulkCollectDeclarationList = sqlNode.getBulkCollectDeclarationList();
        if (sqlNode.getSeqOfDeclareSpecs() == null || sqlNode.getSeqOfDeclareSpecs().getDeclareSpecSqlNodeList() == null) {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "cant find declare variable for bulk collect fetch.");
        }
        List<DeclareSpec> nodes = sqlNode.getSeqOfDeclareSpecs().getDeclareSpecSqlNodeList().getNodes();
        for (DeclareSpec varDeclareSpec : nodes) {
            VariableDeclaration variableDeclaration = varDeclareSpec.getVariableDeclaration();
            if (variableDeclaration == null || !variableDeclaration.getIdentifier().equals(variableName.getText())) continue;
            for (DeclareSpec typeDeclareSpec : nodes) {
                TypeDeclaration typeDeclaration = typeDeclareSpec.getTypeDeclaration();
                if (typeDeclaration == null || !typeDeclaration.getIdentifier().equals(variableDeclaration.getTypeSpec().getTypeName())) continue;
                BulkCollectDeclaration bulkCollectDeclaration = PlsqlProcedureSourceUnParser.getBulkCollectDeclaration(variableName, typeDeclaration);
                typeDeclaration.setBulkCollect(true);
                bulkCollectDeclarationList.add(bulkCollectDeclaration);
                return;
            }
        }
    }

    private static BulkCollectDeclaration getBulkCollectDeclaration(VariableName variableName, TypeDeclaration typeDeclaration) {
        BulkCollectDeclaration bulkCollectDeclaration = new BulkCollectDeclaration();
        bulkCollectDeclaration.setVariableName(variableName);
        if (typeDeclaration.getTableTypeDef() != null) {
            bulkCollectDeclaration.setTypeSpec(typeDeclaration.getTableTypeDef().getTypeSpec());
        } else if (typeDeclaration.getVarrayTypeDef() != null) {
            bulkCollectDeclaration.setTypeSpec(typeDeclaration.getVarrayTypeDef().getTypeSpec());
        } else {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "cant find declare type for bulk collect fetch.");
        }
        return bulkCollectDeclaration;
    }

    private void handleExceptionHandler(PlsqlProcedureSource sqlNode, SqlWriter writer, UnParserContext context) {
        String exceptionHandlers = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.exception.handler", "").toLowerCase(Locale.ROOT).replace(" ", "");
        if (exceptionHandlers.isEmpty()) {
            return;
        }
        List<String> handlerNameList = Arrays.asList(exceptionHandlers.split(","));
        if (handlerNameList.contains(sqlNode.getProcedureName().toLowerCase(Locale.ROOT))) {
            if (sqlNode.getParameterDeclaration() == null) {
                sqlNode.setParameterDeclaration(new SqlNodeList<Parameter>());
            }
            CreateFunctionBodyUnParser.setExceptionParameter(sqlNode.getParameterDeclaration().getNodes());
            context.setExceptionHandler(true);
        }
    }

    private void addPackageConstant(boolean existsDeclare, SqlWriter writer, UnParserContext context) {
        String packageName = context.getPackageName();
        Map<String, String> packageTypeMap = DWSMigrationService.getPackageTypeMap(packageName);
        if (packageTypeMap == null || packageTypeMap.isEmpty()) {
            return;
        }
        Map<String, String> packageOutputMap = DWSMigrationService.getPackageOutputMap(packageName);
        for (Map.Entry<String, String> entry : packageTypeMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase("CONSTANT")) continue;
            if (!existsDeclare) {
                writer.append("DECLARE").newLine();
                existsDeclare = true;
            }
            writer.append(packageOutputMap.get(entry.getKey()));
        }
    }
}

