/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.contextstuct.ScalarSubQueryCtx;
import com.huawei.hwclouds.migration.oracle.model.Atom;
import com.huawei.hwclouds.migration.oracle.model.CompoundExpression;
import com.huawei.hwclouds.migration.oracle.model.Concatenation;
import com.huawei.hwclouds.migration.oracle.model.Condition;
import com.huawei.hwclouds.migration.oracle.model.Constant;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.FetchClause;
import com.huawei.hwclouds.migration.oracle.model.FromList;
import com.huawei.hwclouds.migration.oracle.model.HierarchicalQuery;
import com.huawei.hwclouds.migration.oracle.model.LogicalExpression;
import com.huawei.hwclouds.migration.oracle.model.ModelExpression;
import com.huawei.hwclouds.migration.oracle.model.MultisetExpression;
import com.huawei.hwclouds.migration.oracle.model.OffsetClause;
import com.huawei.hwclouds.migration.oracle.model.QueryBlock;
import com.huawei.hwclouds.migration.oracle.model.QueryTableExpression;
import com.huawei.hwclouds.migration.oracle.model.RelationalExpression;
import com.huawei.hwclouds.migration.oracle.model.SelectListElement;
import com.huawei.hwclouds.migration.oracle.model.TableReference;
import com.huawei.hwclouds.migration.oracle.model.UnaryExpression;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=QueryBlock.class)
public class QueryBlockUnParser
implements UnParser<QueryBlock> {
    @Override
    public void unParse(QueryBlock sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode != null && sqlNode.getFromClause() != null && sqlNode.getFromClause().getSqlFromList() != null && !sqlNode.getFromClause().getSqlFromList().getNodes().isEmpty() && sqlNode.getFromClause().getSqlFromList().getNodes().get(0).getTableReference() != null && sqlNode.getFromClause().getSqlFromList().getNodes().get(0).getTableReference().getQueryTableExpression() != null) {
            context.setTableName(sqlNode.getFromClause().getSqlFromList().getNodes().get(0).getTableReference().getQueryTableExpression().getTableName());
        }
        if (sqlNode.getHierarchicalQuery() != null) {
            this.convertConnectByClause(sqlNode, writer, context);
        }
        if (context.getSelectListChildCount() > 0) {
            ScalarSubQueryCtx scalarSubQueryCtx = new ScalarSubQueryCtx();
            scalarSubQueryCtx.setScalarColumnList(sqlNode.getSelectListElements());
            scalarSubQueryCtx.setScalarFromClause(sqlNode.getFromClause());
            if (sqlNode.getFromClause().getSqlFromList().getNodes().get(0).getTableReference().getTableAlias() != null) {
                scalarSubQueryCtx.setAsName(sqlNode.getFromClause().getSqlFromList().getNodes().get(0).getTableReference().getTableAlias().getIdentifier());
            }
            if (sqlNode.getWhereClause() != null) {
                scalarSubQueryCtx.setScalarWhereClause(sqlNode.getWhereClause());
                this.getColumnInWhereClause(scalarSubQueryCtx, writer, context);
                for (int i = 0; i < scalarSubQueryCtx.getScalarColumnList().getNodes().size(); ++i) {
                    writer.append(scalarSubQueryCtx.getAsName()).append(".");
                    scalarSubQueryCtx.getScalarColumnList().getNodes().get(i).unParse(writer, context);
                }
            }
            if (sqlNode.getWhereClause() == null && context.getStatusForScalar() == 1) {
                writer.append(context.getCountColumn().get(context.getIndOfCountList()));
                context.setIndOfCountList(context.getIndOfCountList() + 1);
            }
            if (context.getStatusForScalar() == 0 && sqlNode.getWhereClause() == null || context.getStatusForScalar() == 1 && sqlNode.getWhereClause() != null) {
                context.getScalarSubQueryCtx().add(scalarSubQueryCtx);
            }
        } else {
            this.ConvertScalarClause(sqlNode, writer, context);
            writer.writeSpace(1).append(" SELECT ");
            if (sqlNode.getQueryType() != null) {
                String queryType = sqlNode.getQueryType().getIdentifier().toUpperCase(Locale.ROOT);
                if (queryType.equals("UNIQUE")) {
                    writer.append("DISTINCT");
                } else {
                    writer.append(queryType);
                }
                writer.writeSpace(1);
            }
            if (sqlNode.isStar()) {
                writer.append(" * ");
            } else {
                List<SelectListElement> selectListElements = sqlNode.getSelectListElements().getNodes();
                for (int i = 0; i < selectListElements.size(); ++i) {
                    context.setSelectListChildCount(context.getSelectListChildCount() + 1);
                    context.setStatusForScalar(1);
                    selectListElements.get(i).unParse(writer, context);
                    context.setStatusForScalar(0);
                    context.setSelectListChildCount(context.getSelectListChildCount() - 1);
                    if (i == selectListElements.size() - 1) continue;
                    writer.append(", ");
                }
            }
            this.dealWithClause(sqlNode, writer, context);
            if (sqlNode.getOffsetClause() != null) {
                OffsetClause offsetClause = sqlNode.getOffsetClause();
                writer.append(" OFFSET ");
                offsetClause.getExpression().unParse(writer, context);
                writer.append(offsetClause.getRow().toString()).writeSpace(1);
            }
            if (sqlNode.getFetchClause() != null) {
                FetchClause fetchClause = sqlNode.getFetchClause();
                writer.append(" FETCH ").append(fetchClause.getFetchType().getIdentifier());
                if (fetchClause.getExpression() != null) {
                    fetchClause.getExpression().unParse(writer, context);
                    if (fetchClause.isPercentKeyword()) {
                        writer.append(" PERCENT");
                    }
                }
                writer.append(fetchClause.getRow().getIdentifier()).writeSpace(1).append(fetchClause.getOnlyOrWithTies().getIdentifier()).writeSpace(1);
            }
            writer.writeSpace(1);
        }
    }

    private void convertConnectByClause(QueryBlock sqlNode, SqlWriter writer, UnParserContext context) {
        String idx = "";
        if (sqlNode.getHierarchicalQuery().getConnectByCondition() != null) {
            context.setHierarchicalQuery(sqlNode.getHierarchicalQuery());
            idx = Optional.ofNullable(sqlNode).map(QueryBlock::getHierarchicalQuery).map(HierarchicalQuery::getConnectByCondition).map(Condition::getExpression).map(Expression::getLogicalExpression).map(LogicalExpression::getMultisetExpression).map(MultisetExpression::getRelationalExpression).map(RelationalExpression::getFRelationalExpression).map(RelationalExpression::getCompoundExpression).map(CompoundExpression::getFConcatenation).map(Concatenation::getModelExpression).map(ModelExpression::getUnaryExpression).map(UnaryExpression::getAtom).map(Atom::getConstant).map(Constant::getQuotedString).orElse("");
        }
        writer.append("WITH RECURSIVE CONNECT_BY_TABLE AS (").append("SELECT ");
        if (sqlNode.getHierarchicalQuery().getStartWithCondition() != null) {
            if (sqlNode.getHierarchicalQuery().getStartWithCondition().getExpression().getLogicalExpression().getMultisetExpression().getRelationalExpression().getSRelationalExpression() != null) {
                sqlNode.getHierarchicalQuery().getStartWithCondition().getExpression().getLogicalExpression().getMultisetExpression().getRelationalExpression().getSRelationalExpression().unParse(writer, context);
            } else {
                sqlNode.getHierarchicalQuery().getStartWithCondition().unParse(writer, context);
            }
        } else {
            writer.append("1");
        }
        writer.append(" AS ").append(idx).writeSpace().append("FROM DUAL").writeSpace().append("UNION ALL").writeSpace().append("SELECT CONNECT_BY_TABLE.").append(idx).append(" + 1 AS ").append(idx).writeSpace().append("FROM CONNECT_BY_TABLE").writeSpace().append("WHERE ");
        sqlNode.getHierarchicalQuery().getConnectByCondition().unParse(writer, context);
        writer.append(")");
    }

    private void ConvertScalarClause(QueryBlock sqlNode, SqlWriter writer, UnParserContext context) {
        SqlWriter cWriter = writer.cloneEmpty();
        List<SelectListElement> selectListElements = sqlNode.getSelectListElements().getNodes();
        for (int i = 0; i < selectListElements.size(); ++i) {
            context.setSelectListChildCount(context.getSelectListChildCount() + 1);
            context.setStatusForScalar(0);
            selectListElements.get(i).unParse(cWriter, context);
            context.setStatusForScalar(0);
            context.setSelectListChildCount(context.getSelectListChildCount() - 1);
        }
        int scalarCntWithoutWhereClause = 0;
        if (context.getScalarSubQueryCtx().size() > 0) {
            for (int i = 0; i < context.getScalarSubQueryCtx().size(); ++i) {
                if (context.getScalarSubQueryCtx().get(i).getScalarWhereClause() != null) continue;
                ++scalarCntWithoutWhereClause;
            }
        }
        if (context.getScalarSubQueryCtx().size() > 0) {
            int scalarCnt = scalarCntWithoutWhereClause;
            for (int i = 0; i < context.getScalarSubQueryCtx().size(); ++i) {
                if (context.getScalarSubQueryCtx().get(i).getScalarWhereClause() != null) continue;
                ScalarSubQueryCtx scalarSubQuery = context.getScalarSubQueryCtx().get(i);
                if (scalarCnt == scalarCntWithoutWhereClause) {
                    writer.append("WITH ");
                }
                String asQueryName = "temp_" + context.getQueryAsName().get(i);
                scalarSubQuery.setAsQueryName(asQueryName);
                this.addTableNameForQueryBlock(sqlNode, asQueryName);
                writer.append(asQueryName).writeSpace(1).append("AS ");
                writer.append("( ");
                writer.append("SELECT ");
                for (int j = 0; j < scalarSubQuery.getScalarColumnList().getNodes().size(); ++j) {
                    scalarSubQuery.getScalarColumnList().getNodes().get(j).unParse(writer, context);
                }
                writer.append(context.getAsNameForScalar()).writeSpace(1);
                scalarSubQuery.setAsQueryName(context.getQueryAsName().get(i));
                writer.append(scalarSubQuery.getAsQueryName()).writeSpace(1);
                context.setDealWithFromClause(false);
                scalarSubQuery.getScalarFromClause().unParse(writer, context);
                context.setDealWithFromClause(true);
                context.getCountColumn().add(asQueryName + "." + context.getQueryAsName().get(i) + " as " + context.getQueryAsName().get(i));
                writer.append(") ");
                if (scalarCntWithoutWhereClause <= 1) continue;
                writer.append(", ");
                --scalarCntWithoutWhereClause;
            }
        }
    }

    private void addTableNameForQueryBlock(QueryBlock sqlNode, String asQueryName) {
        QueryTableExpression queryTableExpression = new QueryTableExpression();
        queryTableExpression.setTableName(asQueryName);
        TableReference tableReference = new TableReference();
        tableReference.setQueryTableExpression(queryTableExpression);
        FromList fromList = new FromList();
        fromList.setDoNotAppend(true);
        fromList.setTableReference(tableReference);
        sqlNode.getFromClause().getSqlFromList().addNode(fromList);
    }

    private void getColumnInWhereClause(ScalarSubQueryCtx scalarSubQueryCtx, SqlWriter writer, UnParserContext context) {
        if (scalarSubQueryCtx.getScalarWhereClause() != null && scalarSubQueryCtx.getScalarWhereClause().getExpression() != null) {
            context.setScalarInWhereClause(true);
            context.setAsNameForScalar(scalarSubQueryCtx.getAsName());
            scalarSubQueryCtx.getScalarWhereClause().getExpression().unParse(writer, context);
            for (int i = 0; i < context.getColumnInWhereClause().size(); ++i) {
                scalarSubQueryCtx.getColumnInWhereClause().add(context.getColumnInWhereClause().get(i));
            }
            context.getColumnInWhereClause().clear();
            context.setAsNameForScalar(null);
            context.setScalarInWhereClause(false);
        }
    }

    private void dealWithClause(QueryBlock sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getIntoClause() != null) {
            sqlNode.getIntoClause().unParse(writer, context);
        }
        if (sqlNode.getFromClause() != null) {
            sqlNode.getFromClause().unParse(writer, context);
        }
        if (sqlNode.getWhereClause() != null) {
            sqlNode.getWhereClause().unParse(writer, context);
        }
        if (sqlNode.getHierarchicalQuery() != null) {
            sqlNode.getHierarchicalQuery().unParse(writer, context);
        }
        if (sqlNode.getGroupByClause() != null) {
            sqlNode.getGroupByClause().unParse(writer, context);
        }
        if (sqlNode.getModelClause() != null) {
            sqlNode.getModelClause().unParse(writer, context);
        }
        if (sqlNode.getOrderByClause() != null) {
            sqlNode.getOrderByClause().unParse(writer, context);
        }
    }
}

