/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.QueryTableExpression;
import com.huawei.hwclouds.migration.oracle.model.SampleClause;
import com.huawei.hwclouds.migration.oracle.model.SubQueryRestriction;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=QueryTableExpression.class)
public class QueryTableExpressionUnParser
implements UnParser<QueryTableExpression> {
    @Override
    public void unParse(QueryTableExpression sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getSubQuery() != null) {
            if (sqlNode.isLateral()) {
                writer.append("LATERAL ");
            }
            writer.append("(");
            sqlNode.getSubQuery().unParse(writer, context);
            SubQueryRestriction subQueryRestriction = sqlNode.getSubQueryRestriction();
            if (subQueryRestriction != null) {
                writer.append(" WITH ").append(subQueryRestriction.getWithType()).append(subQueryRestriction.getConstraintName().getIdentifier()).writeSpace(1);
            }
            writer.append(")");
        }
        this.dealWithExpTableViewName(sqlNode, writer, context);
        writer.writeSpace(1);
    }

    private void dealWithExpTableViewName(QueryTableExpression sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getTableName() != null) {
            if (sqlNode.getTableName().equalsIgnoreCase("DUAL") && context.getHierarchicalQuery() != null) {
                sqlNode.setTableName("CONNECT_BY_TABLE");
            }
            if (sqlNode.getTableName().equalsIgnoreCase("USER_TABLES")) {
                sqlNode.setTableName("PG_TABLES");
            }
            writer.append(sqlNode.getTableName()).writeSpace(1);
            SampleClause sampleClause = sqlNode.getSampleClause();
            if (sampleClause != null) {
                writer.append(" SAMPLE ");
                if (sampleClause.isBlock()) {
                    writer.append("BLOCK ");
                }
                writer.append("(");
                sampleClause.getSamplePercent().unParse(writer, context);
                writer.append(")");
                if (sampleClause.getSeedValue() != null) {
                    writer.append(" SEED (");
                    sampleClause.getSeedValue().unParse(writer, context);
                    writer.append(")");
                }
            }
        }
    }
}

