/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.ConstraintState;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.ReferencesClause;
import com.huawei.hwclouds.migration.oracle.model.RelationalProperty;
import com.huawei.hwclouds.migration.oracle.model.TableConstraint;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=RelationalProperty.class)
public class RelationalPropertyUnParser
implements UnParser<RelationalProperty> {
    @Override
    public void unParse(RelationalProperty sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        boolean isComment = ConfigUtil.getConfigValue(config, "table.foreign.key.comment", "false").equalsIgnoreCase("true");
        if (sqlNode.getColumnDefinition() != null) {
            sqlNode.getColumnDefinition().unParse(writer, context);
        } else if (sqlNode.getTableConstraint() != null) {
            TableConstraint tableConstraint = sqlNode.getTableConstraint();
            String constraintType = tableConstraint.getConstraintType().getIdentifier();
            boolean isForeignKey = constraintType.toUpperCase(Locale.ROOT).equals("FOREIGN KEY");
            if (isForeignKey && isComment) {
                writer.append(" /* ");
            }
            this.constraintType(writer, context, tableConstraint);
            this.constraintColumn(writer, context, tableConstraint.getColumns());
            this.referencesClause(writer, context, tableConstraint.getReferencesClause());
            this.constraintStates(writer, context, tableConstraint.getConstraintStates());
            if (isForeignKey && isComment) {
                writer.append(" */ ");
            }
        } else if (sqlNode.getSupplementalLoggingProps() != null) {
            writer.append("/* ").append(sqlNode.getSupplementalLoggingProps()).append("*/ ");
        }
    }

    private void constraintStates(SqlWriter writer, UnParserContext context, SqlNodeList<ConstraintState> constraintStates) {
        if (constraintStates != null && constraintStates.getNodes().size() > 0) {
            List<ConstraintState> statesNodes = constraintStates.getNodes();
            for (int i = 0; i < statesNodes.size(); ++i) {
                ConstraintState constraintState = statesNodes.get(i);
                if (constraintState.getUsingIndex() != null) {
                    constraintState.getUsingIndex().unParse(writer, context);
                }
                writer.writeSpace(1);
            }
        }
    }

    private void referencesClause(SqlWriter writer, UnParserContext context, ReferencesClause referencesClause) {
        if (referencesClause != null) {
            writer.append("REFERENCES ");
            referencesClause.getTableName().unParse(writer, context);
            this.constraintColumn(writer, context, referencesClause.getColumns());
            if (referencesClause.getOnDeleteType() != null) {
                writer.writeSpace(1).append(referencesClause.getOnDeleteType());
            }
            writer.writeSpace(1);
        }
    }

    private void constraintType(SqlWriter writer, UnParserContext context, TableConstraint tableConstraint) {
        if (tableConstraint != null) {
            if (tableConstraint.getConstraintName() != null) {
                writer.append("CONSTRAINT").writeSpace(1);
                tableConstraint.getConstraintName().unParse(writer, context);
                writer.writeSpace(1);
            }
            SqlWriter sqlWriter = writer.cloneEmpty();
            tableConstraint.getConstraintType().unParse(sqlWriter, context);
            String type = sqlWriter.toSqlString().getSql();
            switch (type.toUpperCase(Locale.ROOT)) {
                case "\"PRIMARY KEY\"": {
                    writer.append("PRIMARY KEY");
                    break;
                }
                case "\"UNIQUE\"": {
                    writer.append("UNIQUE");
                    break;
                }
                case "\"CHECK\"": {
                    writer.append("CHECK");
                    break;
                }
                case "\"FOREIGN KEY\"": {
                    writer.append("FOREIGN KEY");
                    break;
                }
            }
            writer.writeSpace(1);
        }
    }

    private void constraintColumn(SqlWriter writer, UnParserContext context, SqlNodeList<Identifier> columns) {
        if (columns != null && columns.getNodes().size() > 0) {
            List<Identifier> nodes = columns.getNodes();
            writer.append("(").writeSpace(1);
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).unParse(writer, context);
                if (i == nodes.size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
            writer.append(")").writeSpace(1);
        }
    }
}

