/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.AlterSession;
import com.huawei.hwclouds.migration.oracle.model.RoleStruct;
import com.huawei.hwclouds.migration.oracle.model.SessionControlStatement;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SessionControlStatement.class)
public class SessionControlStatementUnParser
implements UnParser<SessionControlStatement> {
    @Override
    public void unParse(SessionControlStatement sqlNode, SqlWriter writer, UnParserContext context) {
        boolean needComment = this.judgCommentScenes(sqlNode);
        if (needComment) {
            writer.append("/* ");
        }
        if (sqlNode.getAlterSession() != null) {
            AlterSession alterSession = sqlNode.getAlterSession();
            writer.append("ALTER SESSION ");
            switch (alterSession.getKeyWord()) {
                case "ADVISE": {
                    writer.append("ADVISE " + alterSession.getTransactionsKeyWord()).writeSpace(1);
                    break;
                }
                case "CLOSE": {
                    writer.append("CLOSE DATABASE LINK ").append(alterSession.getParameterNameOrLiteral()).writeSpace(1);
                    break;
                }
                case "PROCEDURE": {
                    writer.append(alterSession.getEnableOrDisable()).writeSpace(1).append("COMMIT IN PROCEDURE ");
                    break;
                }
                case "GUARD": {
                    writer.append(alterSession.getEnableOrDisable()).writeSpace(1).append("GUARD ");
                    break;
                }
                case "PARALLEL": {
                    writer.append(alterSession.getEnableOrDisable()).writeSpace(1).append("PARALLEL ");
                    writer.append(alterSession.getSqlType()).writeSpace(1);
                    if (alterSession.getParameterNameOrLiteral() == null) break;
                    writer.append("PARALLEL ").append(alterSession.getParameterNameOrLiteral()).writeSpace(1);
                    break;
                }
                case "SET": {
                    writer.append("SET ");
                    writer.append(alterSession.getAlterSessionSetClause().getParameterName()).writeSpace(1).append("= ").append(alterSession.getAlterSessionSetClause().getParameterValue()).writeSpace(1);
                    break;
                }
            }
        } else {
            RoleStruct roleStruct = sqlNode.getRoleStruct();
            switch (roleStruct.getRoleType()) {
                case "ALTER ROLE": {
                    writer.append("ALTER ROLE ").append(roleStruct.getRoleName()).writeSpace(1).append(roleStruct.getRoleIdentifiedClause()).writeSpace(1);
                    if (roleStruct.getContainerClause() == null) break;
                    writer.append(roleStruct.getContainerClause()).writeSpace(1);
                    break;
                }
                case "CREATE ROLE": {
                    writer.append("CREATE ROLE ").append(roleStruct.getRoleName()).writeSpace(1);
                    if (roleStruct.getRoleIdentifiedClause() != null) {
                        writer.append(roleStruct.getRoleIdentifiedClause()).writeSpace(1);
                    }
                    if (roleStruct.getContainerClause() == null) break;
                    writer.append(roleStruct.getContainerClause()).writeSpace(1);
                    break;
                }
                case "DROP ROLE": {
                    writer.append("DROP ROLE ").append(roleStruct.getRoleName()).writeSpace(1);
                    break;
                }
            }
        }
        if (needComment) {
            writer.append(" */ ");
        }
    }

    private boolean judgCommentScenes(SessionControlStatement sqlNode) {
        if (sqlNode.getAlterSession() != null && sqlNode.getAlterSession().getKeyWord().equalsIgnoreCase("SET")) {
            return !sqlNode.getAlterSession().getAlterSessionSetClause().getParameterName().equalsIgnoreCase("CURRENT_SCHEMA");
        }
        return true;
    }
}

