/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.StandardFunction;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=StandardFunction.class)
public class StandardFunctionUnParser
implements UnParser<StandardFunction> {
    private static volatile Map<String, String> functionNameMap = null;

    @Override
    public void unParse(StandardFunction sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getStringFunction() != null) {
            sqlNode.getStringFunction().unParse(writer, context);
        } else if (sqlNode.getNumericFunctionWrapper() != null) {
            sqlNode.getNumericFunctionWrapper().unParse(writer, context);
        } else if (sqlNode.getOtherFunction() != null) {
            sqlNode.getOtherFunction().unParse(writer, context);
        } else if (sqlNode.getSystemFunction() != null) {
            sqlNode.getSystemFunction().unParse(writer, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initFunctionNameMap(SqlWriter writer) {
        if (functionNameMap != null) return;
        Class<StandardFunctionUnParser> clazz = StandardFunctionUnParser.class;
        synchronized (StandardFunctionUnParser.class) {
            if (functionNameMap != null) return;
            functionNameMap = new HashMap<String, String>();
            String functionNameConvertStr = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.output.function.name.convert", "");
            if (functionNameConvertStr == null || functionNameConvertStr.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (String single : functionNameConvertStr.split(",")) {
                if (!single.contains("|")) continue;
                String[] split = single.split("\\|");
                functionNameMap.put(split[0].toUpperCase(Locale.ROOT).trim(), split[1]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String convertFunctionName(String functionName, SqlWriter writer) {
        StandardFunctionUnParser.initFunctionNameMap(writer);
        if (functionNameMap == null || functionNameMap.isEmpty() || !functionNameMap.containsKey(functionName.trim().toUpperCase(Locale.ROOT))) {
            return functionName;
        }
        return functionNameMap.get(functionName.trim().toUpperCase(Locale.ROOT));
    }
}

