/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.util.ConvertUtil;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Argument;
import com.huawei.hwclouds.migration.oracle.model.Atom;
import com.huawei.hwclouds.migration.oracle.model.CompoundExpression;
import com.huawei.hwclouds.migration.oracle.model.Concatenation;
import com.huawei.hwclouds.migration.oracle.model.Constant;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.FunctionArgument;
import com.huawei.hwclouds.migration.oracle.model.FunctionListAgg;
import com.huawei.hwclouds.migration.oracle.model.ListaggOverflowClause;
import com.huawei.hwclouds.migration.oracle.model.LogicalExpression;
import com.huawei.hwclouds.migration.oracle.model.ModelExpression;
import com.huawei.hwclouds.migration.oracle.model.MultisetExpression;
import com.huawei.hwclouds.migration.oracle.model.RelationalExpression;
import com.huawei.hwclouds.migration.oracle.model.SystemFunction;
import com.huawei.hwclouds.migration.oracle.model.UnaryExpression;
import com.huawei.hwclouds.migration.oracle.unparser.StandardFunctionUnParser;
import com.huawei.hwclouds.migration.oracle.util.GetArgumentUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SystemFunction.class)
public class SystemFunctionUnParser
implements UnParser<SystemFunction> {
    @Override
    public void unParse(SystemFunction sqlNode, SqlWriter writer, UnParserContext context) {
        sqlNode.setFuncName(StandardFunctionUnParser.convertFunctionName(sqlNode.getFuncName(), writer));
        this.doConvertSpecialFunction(sqlNode);
        if (sqlNode.getFunctionSystimestamp() != null) {
            writer.append(sqlNode.getFunctionSystimestamp()).writeSpace(1);
        } else if (sqlNode.getFunctionDbmsLob() != null) {
            writer.append(sqlNode.getFunctionDbmsLob().getFuncName());
            writer.append("( ");
            sqlNode.getFunctionDbmsLob().getFunctionArgument().unParse(writer, context);
            writer.append(")").writeSpace(1);
        } else if (sqlNode.getFunctionListAgg() != null) {
            FunctionListAgg functionListAgg = sqlNode.getFunctionListAgg();
            writer.append("LISTAGG( ");
            if (functionListAgg.getQueryType() != null) {
                writer.append(functionListAgg.getQueryType()).writeSpace(1);
            }
            functionListAgg.getFunctionArgument().unParse(writer, context);
            if (functionListAgg.getListaggOverflowClause() != null) {
                ListaggOverflowClause listaggOverflowClause = functionListAgg.getListaggOverflowClause();
                writer.append("ON OVERFLOW ");
                writer.append(listaggOverflowClause.getOverflowKeyword()).writeSpace(1);
                writer.append(listaggOverflowClause.getWithClause()).writeSpace(1);
            }
            writer.append(")").writeSpace(1);
            if (functionListAgg.getOrderByClause() != null) {
                writer.append("WITHIN GROUP ( ");
                functionListAgg.getOrderByClause().unParse(writer, context);
                writer.append(")").writeSpace(1);
            }
            if (functionListAgg.getOverClause() != null) {
                functionListAgg.getOverClause().unParse(writer, context);
            }
        } else if (sqlNode.getFuncName() != null) {
            String funcName = ConvertUtil.functionConvert(sqlNode.getFuncName());
            writer.append(funcName);
            writer.append("( ");
            sqlNode.getFunctionArgument().unParse(writer, context);
            writer.append(")").writeSpace(1);
        }
    }

    private void doConvertSpecialFunction(SystemFunction sqlNode) {
        if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("TRUNC")) {
            UnaryExpression unaryExpression = sqlNode.getFunctionArgument().getArgumentList().get(0).getExpression().getLogicalExpression().getMultisetExpression().getRelationalExpression().getCompoundExpression().getFConcatenation().getModelExpression().getUnaryExpression();
            if (unaryExpression.getAtom() != null && unaryExpression.getAtom().getConstant().getDateConstant() != null || unaryExpression.getStandardFunction() != null && unaryExpression.getStandardFunction().getSystemFunction() != null && unaryExpression.getStandardFunction().getSystemFunction().getFuncName().equalsIgnoreCase("to_date")) {
                FunctionArgument functionArguments = sqlNode.getFunctionArgument();
                sqlNode.setFuncName("DATE_TRUNC");
                if (functionArguments.getArgumentList().size() == 2 || functionArguments.getArgumentList().size() == 1) {
                    String truncTypeValueStr = "'DD'";
                    if (functionArguments.getArgumentList().size() == 2) {
                        Argument truncTypeArgument = functionArguments.getArgumentList().get(1);
                        truncTypeValueStr = Optional.ofNullable(truncTypeArgument).map(Argument::getExpression).map(Expression::getLogicalExpression).map(LogicalExpression::getMultisetExpression).map(MultisetExpression::getRelationalExpression).map(RelationalExpression::getCompoundExpression).map(CompoundExpression::getFConcatenation).map(Concatenation::getModelExpression).map(ModelExpression::getUnaryExpression).map(UnaryExpression::getAtom).map(Atom::getConstant).map(Constant::getQuotedString).map(str -> str.replace("\"", "")).orElse("'DD'");
                    }
                    HashMap<String, String> truncTypeToUnitMapping = new HashMap<String, String>();
                    truncTypeToUnitMapping.put("'MI'", "minute");
                    truncTypeToUnitMapping.put("'HH'", "hour");
                    truncTypeToUnitMapping.put("'HH12'", "hour");
                    truncTypeToUnitMapping.put("'HH24'", "hour");
                    truncTypeToUnitMapping.put("'DD'", "day");
                    truncTypeToUnitMapping.put("'MM'", "month");
                    truncTypeToUnitMapping.put("'Q'", "quarter");
                    truncTypeToUnitMapping.put("'YYYY'", "year");
                    truncTypeToUnitMapping.put("'YYY'", "year");
                    truncTypeToUnitMapping.put("'YY'", "year");
                    truncTypeToUnitMapping.put("'Y'", "year");
                    truncTypeToUnitMapping.put("'IW'", "week");
                    if (truncTypeValueStr != null && truncTypeToUnitMapping.containsKey(truncTypeValueStr.toUpperCase(Locale.ROOT))) {
                        ArrayList<Argument> newArgumentsList = new ArrayList<Argument>();
                        Constant truncUnitConstant = new Constant();
                        truncUnitConstant.setQuotedString("'" + (String)truncTypeToUnitMapping.get(truncTypeValueStr.toUpperCase(Locale.ROOT)) + "'");
                        Argument truncUnitArgument = GetArgumentUtil.extracted(truncUnitConstant);
                        newArgumentsList.add(truncUnitArgument);
                        newArgumentsList.add(functionArguments.getArgumentList().get(0));
                        functionArguments.setArgumentList(newArgumentsList);
                        sqlNode.setFunctionArgument(functionArguments);
                    }
                }
            }
        } else if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("to_date")) {
            FunctionArgument functionArgument = sqlNode.getFunctionArgument();
            if (functionArgument.getArgumentList().size() == 3) {
                functionArgument.getArgumentList().remove(2);
            }
            sqlNode.setFunctionArgument(functionArgument);
        } else if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("months_between")) {
            Constant constant = new Constant();
            constant.setQuotedString("month");
            Argument argument = GetArgumentUtil.extracted(constant);
            FunctionArgument functionArgument = sqlNode.getFunctionArgument();
            functionArgument.setFuncName("TIMESTAMPDIFF");
            ArrayList<Argument> newArgumentList = new ArrayList<Argument>();
            newArgumentList.add(argument);
            newArgumentList.add(functionArgument.getArgumentList().get(1));
            newArgumentList.add(functionArgument.getArgumentList().get(0));
            functionArgument.setArgumentList(newArgumentList);
            sqlNode.setFunctionArgument(functionArgument);
            sqlNode.setFuncName("TIMESTAMPDIFF");
        } else if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("nvl2")) {
            Constant constant = new Constant();
            constant.setOtherConstant("null");
            Argument argument = GetArgumentUtil.extracted(constant);
            FunctionArgument functionArgument = sqlNode.getFunctionArgument();
            functionArgument.setFuncName("DECODE");
            ArrayList<Argument> newArgumentList = new ArrayList<Argument>();
            newArgumentList.add(functionArgument.getArgumentList().get(0));
            newArgumentList.add(argument);
            newArgumentList.add(functionArgument.getArgumentList().get(2));
            newArgumentList.add(functionArgument.getArgumentList().get(1));
            functionArgument.setArgumentList(newArgumentList);
            sqlNode.setFunctionArgument(functionArgument);
            sqlNode.setFuncName("DECODE");
        } else if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("REPLACE")) {
            FunctionArgument functionArgument = sqlNode.getFunctionArgument();
            if (functionArgument.getArgumentList() != null && functionArgument.getArgumentList().size() == 2) {
                Constant constant = new Constant();
                constant.setOtherConstant("''");
                Argument argument = GetArgumentUtil.extracted(constant);
                functionArgument.getArgumentList().add(argument);
            }
        } else if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("wm_concat")) {
            sqlNode.setFuncName("GROUP_CONCAT");
        }
    }
}

