/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.TransactionControlStatements;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TransactionControlStatements.class)
public class TransactionControlUnParser
implements UnParser<TransactionControlStatements> {
    @Override
    public void unParse(TransactionControlStatements sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getSavePointName() != null) {
            writer.append("SAVEPOINT ").append(sqlNode.getSavePointName());
        }
        if (sqlNode.getSetTransaction() != null) {
            sqlNode.getSetTransaction().unParse(writer, context);
        }
        if (sqlNode.getSetConstraints() != null) {
            sqlNode.getSetConstraints().unParse(writer, context);
        }
        if (sqlNode.getCommitStatement() != null) {
            if (context.isSubTransactionInplsql()) {
                writer.append("/* ");
                sqlNode.getCommitStatement().unParse(writer, context);
                writer.append(" */ ");
                writer.append("NULL ");
            } else if (!context.isProcedure()) {
                sqlNode.getCommitStatement().unParse(writer, context);
            } else {
                writer.append("/* ");
                sqlNode.getCommitStatement().unParse(writer, context);
                writer.append("*/SIGN_DSC_FORMAT_002");
            }
        }
        if (sqlNode.getRollbackStatement() != null) {
            if (context.isSubTransactionInplsql()) {
                writer.append("/* ");
                sqlNode.getRollbackStatement().unParse(writer, context);
                writer.append(" */ ");
                writer.append("NULL ");
            } else if (!context.isProcedure()) {
                sqlNode.getRollbackStatement().unParse(writer, context);
            } else {
                writer.append("/* ");
                sqlNode.getRollbackStatement().unParse(writer, context);
                writer.append("*/SIGN_DSC_FORMAT_002");
            }
        }
    }
}

