/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.FieldSpec;
import com.huawei.hwclouds.migration.oracle.model.TableTypeDef;
import com.huawei.hwclouds.migration.oracle.model.TypeDeclaration;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TypeDeclaration.class)
public class TypeDeclarationUnParser
implements UnParser<TypeDeclaration> {
    @Override
    public void unParse(TypeDeclaration sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("TYPE ").append(sqlNode.getIdentifier()).writeSpace(1).append("IS ");
        if (sqlNode.getTableTypeDef() != null) {
            TableTypeDef tableTypeDef = sqlNode.getTableTypeDef();
            if (sqlNode.isBulkCollect()) {
                writer.append("VARRAY(50) OF ");
            } else {
                writer.append("TABLE OF ");
            }
            tableTypeDef.getTypeSpec().unParse(writer, context);
            if (tableTypeDef.getTableIndexedByPart() != null) {
                writer.append(tableTypeDef.getTableIndexedByPart().getIndexKeyword()).writeSpace(1).append("BY ");
                tableTypeDef.getTableIndexedByPart().getTypeSpec().unParse(writer, context);
            }
            if (tableTypeDef.isExistNotNull()) {
                writer.append("NOT NULL ");
            }
        } else if (sqlNode.getVarrayTypeDef() != null) {
            sqlNode.getVarrayTypeDef().unParse(writer, context);
        } else if (sqlNode.getRecordTypeDef() != null) {
            SqlNodeList<FieldSpec> recordTypeDef = sqlNode.getRecordTypeDef();
            writer.append("RECORD ");
            writer.append("( ");
            for (int i = 0; i < recordTypeDef.getNodes().size(); ++i) {
                recordTypeDef.getNodes().get(i).unParse(writer, context);
                if (i == recordTypeDef.getNodes().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        } else {
            writer.append("REF CURSOR ");
            if (sqlNode.getRefCursorTypeDef().getTypeSpec() != null) {
                writer.append("RETURN ");
                sqlNode.getRefCursorTypeDef().getTypeSpec().unParse(writer, context);
            }
        }
        writer.append("; ");
    }
}

