/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.DWSMigrationService;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.config.PackageTypeEnum;
import com.huawei.hwclouds.migration.oracle.model.TypeSpec;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.Locale;
import java.util.Map;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TypeSpec.class)
public class TypeSpecUnParser
implements UnParser<TypeSpec> {
    @Override
    public void unParse(TypeSpec sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getDataType() != null) {
            sqlNode.getDataType().unParse(writer, context);
        } else {
            this.handlePackageType(sqlNode, context);
            if (sqlNode.isExistRef()) {
                writer.append("REF ");
            }
            if (sqlNode.getTypeName().toLowerCase(Locale.ROOT).equals("ref_cursor")) {
                writer.append("refcursor");
            } else {
                writer.append(sqlNode.getTypeName());
            }
            if (sqlNode.getPercent() != null) {
                writer.writeSpace(1).append(sqlNode.getPercent()).writeSpace(1);
            }
        }
    }

    private void handlePackageType(TypeSpec sqlNode, UnParserContext context) {
        String packageName = context.getPackageName();
        if (packageName == null || packageName.isEmpty() || sqlNode.getTypeName() == null) {
            return;
        }
        Map<String, String> packageTypeMap = DWSMigrationService.getPackageTypeMap(packageName);
        if (packageTypeMap == null || packageTypeMap.isEmpty()) {
            return;
        }
        String typeName = sqlNode.getTypeName().toUpperCase(Locale.ROOT);
        if (packageTypeMap.containsKey(typeName)) {
            Map<String, String> outputMap;
            String packType = packageTypeMap.get(typeName);
            if (PackageTypeEnum.CURSOR.name().equals(packType)) {
                sqlNode.setTypeName("REFCURSOR");
            } else if (PackageTypeEnum.RECORD.name().equals(packType)) {
                sqlNode.setTypeName(packageName + "_" + sqlNode.getTypeName());
            } else if (PackageTypeEnum.TABLE.name().equals(packType) && (outputMap = DWSMigrationService.getPackageOutputMap(packageName)) != null) {
                sqlNode.setTypeName(outputMap.get(typeName));
            }
        }
    }
}

