/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.ColumnBasedUpdateSetClause;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.UpdateSetClause;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=UpdateSetClause.class)
public class UpdateSetClauseUnParser
implements UnParser<UpdateSetClause> {
    @Override
    public void unParse(UpdateSetClause sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(" SET ");
        if (sqlNode.getUpdateSetClauses() != null) {
            List<ColumnBasedUpdateSetClause> updateSetClauses = sqlNode.getUpdateSetClauses();
            for (int i = 0; i < updateSetClauses.size(); ++i) {
                this.dealColumnBasedUpdateSetClause(updateSetClauses.get(i), writer, context);
                if (i == updateSetClauses.size() - 1) continue;
                writer.append(", ");
            }
        } else {
            writer.append(" VALUE ( ").append(sqlNode.getValueKey()).append(" ) = ");
            sqlNode.getValueExpression().unParse(writer, context);
        }
    }

    private void dealColumnBasedUpdateSetClause(ColumnBasedUpdateSetClause clause, SqlWriter writer, UnParserContext context) {
        if (clause.getColumnName() != null) {
            writer.append(clause.getColumnName().getIdentifier()).append(" = ");
            clause.getColumnExpression().unParse(writer, context);
        } else {
            List<Identifier> columns = clause.getColumnList().getNodes();
            writer.append(" ( ");
            for (int i = 0; i < columns.size(); ++i) {
                writer.append(columns.get(i).getIdentifier());
                if (i == columns.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(" ) = ");
            clause.getColumnsSubQuery().unParse(writer, context);
        }
    }
}

