/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Atom;
import com.huawei.hwclouds.migration.oracle.model.CompoundExpression;
import com.huawei.hwclouds.migration.oracle.model.Concatenation;
import com.huawei.hwclouds.migration.oracle.model.Constant;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.LogicalExpression;
import com.huawei.hwclouds.migration.oracle.model.ModelExpression;
import com.huawei.hwclouds.migration.oracle.model.MultisetExpression;
import com.huawei.hwclouds.migration.oracle.model.RelationalExpression;
import com.huawei.hwclouds.migration.oracle.model.UnaryExpression;
import com.huawei.hwclouds.migration.oracle.model.WhereClause;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.Optional;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=WhereClause.class)
public class WhereClauseUnParser
implements UnParser<WhereClause> {
    @Override
    public void unParse(WhereClause sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(" WHERE ");
        if (context.getTableName() != null && context.getTableName().equals("USER_TABLES")) {
            ConvertConfig config;
            String schemaValue;
            Constant constant = Optional.ofNullable(sqlNode).map(WhereClause::getExpression).map(Expression::getLogicalExpression).map(LogicalExpression::getMultisetExpression).map(MultisetExpression::getRelationalExpression).map(RelationalExpression::getFRelationalExpression).map(RelationalExpression::getCompoundExpression).map(CompoundExpression::getFConcatenation).map(Concatenation::getModelExpression).map(ModelExpression::getUnaryExpression).map(UnaryExpression::getAtom).map(Atom::getConstant).orElse(null);
            if (constant != null && constant.getQuotedString() != null && constant.getQuotedString().equals("TABLE_NAME")) {
                constant.setQuotedString("TABLENAME");
            }
            if ((schemaValue = ConfigUtil.getConfigValue(config = writer.getConfig("param.config.flag"), "table.defaultSchema", null)) != null && !schemaValue.trim().isEmpty()) {
                writer.append("AND schemaname = ''");
                writer.append(schemaValue);
                writer.append("''");
            }
        }
        if (sqlNode.getExpression() != null) {
            sqlNode.getExpression().unParse(writer, context);
        }
        if (sqlNode.getSqlCursorName() != null) {
            writer.append("CURRENT OF ").append(sqlNode.getSqlCursorName().getIdentifier());
        }
    }
}

