/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.util;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

public class SqlWriteUtil {
    public static final String MBRCOORDLIST = "MDSYS.MBRCOORDLIST";
    public static final String SDO_GEOMETRY = "MDSYS.SDO_GEOMETRY";
    public static final String GEOMETRY = "MDSYS.GEOMETRY";

    public static void appendSqlIdentifier(SqlWriter writer, UnParserContext context, List<Identifier> nodes, boolean isUseUnParser) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (isUseUnParser) {
                nodes.get(i).unParse(writer, context);
            } else {
                writer.append(nodes.get(i).getIdentifier());
            }
            if (i == nodes.size() - 1) continue;
            writer.append(",").writeSpace(1);
        }
    }

    public static void typeNameExchange(SqlWriter writer, Identifier typeName) {
        String typeNameCase;
        switch (typeNameCase = typeName.getIdentifier().toUpperCase(Locale.ROOT)) {
            case "MDSYS.MBRCOORDLIST": 
            case "MDSYS.SDO_GEOMETRY": 
            case "MDSYS.GEOMETRY": {
                writer.append("CLOB");
                break;
            }
            default: {
                writer.append(typeNameCase);
            }
        }
    }

    public static String handleInsensitive(String identifier, SqlWriter writer) {
        identifier = QuoteUtils.removeDoubleQuote(identifier);
        ConvertConfig configForCase = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(configForCase, "table.create.inSensitive", "true").equalsIgnoreCase("true")) {
            return QuoteUtils.addDoubleQuote(identifier.toLowerCase(Locale.ROOT));
        }
        return QuoteUtils.addDoubleQuote(identifier);
    }
}

