/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.common.util;

import com.huawei.hwclouds.migration.common.util.ClassHandler;
import com.huawei.hwclouds.migration.common.util.ConvertRuntimeException;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassScanner {
    private static final Logger LOGGER = LogManager.getLogger(ClassScanner.class);
    private static final String ENCODING = "UTF-8";
    private ClassHandler classHandler = null;

    public ClassScanner(ClassHandler classHandler) {
        this.classHandler = classHandler;
    }

    public void scan(String basePackage) {
        String packageName = basePackage;
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(46));
        }
        String package2Path = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(package2Path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                LOGGER.debug("scan classes in {}.", (Object)url.toString());
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), ENCODING);
                    this.doScanPackageClassesByFile(packageName, filePath);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                this.doScanPackageClassesByJar(packageName, url);
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException error:", (Throwable)e);
            throw new ConvertRuntimeException("Failed to scan classes. ", e);
        }
    }

    private void doScanPackageClassesByJar(String basePackage, URL url) {
        String pkgName = basePackage;
        String pkgPath2 = pkgName.replace('.', '/');
        JarFile jarFile = null;
        try {
            jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(pkgPath2) || entry.isDirectory()) continue;
                String classSimpleName = name.substring(name.lastIndexOf(47) + 1);
                this.filterClassName(pkgName, classSimpleName);
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException error:", (Throwable)e);
            throw new ConvertRuntimeException("Failed to scan classes. ", e);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("resource close failed");
            }
        }
    }

    private void doScanPackageClassesByFile(String packageName, String packagePath) throws IOException {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles();
        if (dirFiles != null && dirFiles.length > 0) {
            for (File file : dirFiles) {
                if (file.isDirectory()) {
                    this.doScanPackageClassesByFile(packageName + "." + file.getName(), file.getCanonicalPath());
                    continue;
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className);
                    this.classHandler.handle(clazz);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("IOException error:", (Throwable)e);
                    throw new ConvertRuntimeException("Failed to scan classes. ", e);
                }
            }
        }
    }

    private void filterClassName(String packageName, String className) {
        if (!className.endsWith(".class")) {
            return;
        }
        if (null == this.classHandler) {
            return;
        }
        String tmpName = className.substring(0, className.length() - 6);
        String filePackage = tmpName.replaceAll("\\\\", ".");
        try {
            Class<?> clazz = Class.forName(packageName + "." + filePackage);
            this.classHandler.handle(clazz);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("IOException error:", (Throwable)e);
            throw new ConvertRuntimeException("Failed to scan classes. ", e);
        }
    }
}

