/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.languages.Dialect;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.hive.DWSMain;
import com.huawei.hwclouds.migration.hive.HiveConvertor;
import com.huawei.hwclouds.migration.hive.config.ApplicationPropertyLoader;
import com.huawei.hwclouds.migration.hive.util.CommonUtils;
import com.huawei.hwclouds.migration.hive.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.hive.util.SqlString;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMigration
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DWSMigration.class);
    private static int fileNumber = 0;
    private final File inputFile;
    private final String outputFile;
    private DatabaseConvertor convertor;
    private final int range;
    private final int countValidFiles;
    private static final Pattern PROC_FINDER = Pattern.compile("(?i)^(CREATE)[\\S+\\s+]*(PROCEDURE|FUNCTION|TRIGGER)(\\s+)(.*?)");
    private static final Pattern BEGIN_FINDER = Pattern.compile("(?i)[\\S+\\s+]*begin(\\s?)");

    DWSMigration(File inFile, String outFile, int rangNum, int countValidFilesNum) {
        this.inputFile = inFile;
        this.outputFile = outFile;
        this.range = rangNum;
        this.countValidFiles = countValidFilesNum;
        this.convertor = new HiveConvertor(null);
    }

    @Override
    public void run() {
        try {
            String resSql = DWSMigration.parseFile(this.inputFile, this.convertor, this.range);
            if (resSql == null) {
                DWSMain.FAILED_FILES.incrementAndGet();
                return;
            }
            boolean fileCreate = CommonUtils.createNewFile(this.outputFile, false);
            if (!fileCreate) {
                LOGGER.error("Error while creating file");
                return;
            }
            String encodingFormat = DWSMigration.getEncodingFormat();
            FileUtils.write((File)new File(this.outputFile), (CharSequence)resSql, (String)encodingFormat);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse " + this.inputFile.getName(), (Throwable)e);
            try {
                FileUtils.copyFile((File)this.inputFile, (File)new File(this.outputFile));
            }
            catch (IOException pe) {
                LOGGER.error("Faild to copy file " + this.inputFile.getName());
            }
            DWSMain.FAILED_FILES.incrementAndGet();
        }
        int percent = 100;
        DWSMigration.incrementFileCounter();
        int status = this.countValidFiles > 0 ? fileNumber * 100 / this.countValidFiles : 0;
        DWSMain.printConsoleMessage(status + "% completed");
    }

    private static void incrementFileCounter() {
        ++fileNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static String parseFile(File inputFile, DatabaseConvertor convertor, int rangeNum) throws IOException {
        resSql = new StringBuilder();
        sb = new StringBuilder();
        encodingFormat = DWSMigration.getEncodingFormat();
        validLength = rangeNum;
        it = FileUtils.lineIterator((File)inputFile, (String)encodingFormat);
lbl6:
        // 2 sources

        try {
            while (it.hasNext()) {
                block14: {
                    line = it.nextLine();
                    if (line == null || !DWSMigration.isSqlComment(line)) break block14;
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    if (!line.trim().startsWith("/*")) continue;
                    while (!line.trim().startsWith("*/") && !line.trim().endsWith("*/") && it.hasNext()) {
                        line = it.nextLine();
                        sb.append(line).append('\n');
                    }
                    ** GOTO lbl6
                }
                if ((line = DWSMigration.getBeginWithEndString(sb, it, line)) == null) continue;
                if (line != null && line.trim().endsWith(";")) {
                    length = line.trim().length();
                    if (length == 1) {
                        lastInput = sb.toString().trim();
                        sb.delete(0, sb.length());
                        sb.append(lastInput);
                    }
                    sb.append(line);
                    inputLen = sb.length();
                    if (inputLen > validLength || inputLen <= 1) {
                        DWSMigration.LOGGER.error("Migration of the following file exceeds the max Sql Length: {}", (Object)inputFile.toString());
                        var11_14 = null;
                        return var11_14;
                    }
                    altString = sb.toString().toUpperCase(Locale.ROOT);
                    if (altString.contains("SET @@") || altString.contains("SET @")) {
                        sql = new StringBuilder();
                        DWSMigration.LOGGER.warn("Sql syntax not supported:PLSQL SET @@/@, FileName:" + inputFile.getName() + ", OriSql:" + sb.toString());
                        DWSMain.FAILED_SQL.incrementAndGet();
                        resSql.append((CharSequence)sql.append("/* sql not support\r\n").append((CharSequence)sb).append("*/;"));
                    } else {
                        DWSMigration.convertSql(inputFile, convertor, sb, resSql);
                        resSql.append(System.lineSeparator());
                    }
                    sb.append(System.lineSeparator());
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(line);
                if ((line == null || line.isEmpty()) && sb.toString().trim().isEmpty()) {
                    resSql.append(System.lineSeparator());
                    continue;
                }
                sb.append(System.lineSeparator());
            }
            DWSMigration.convertSql(inputFile, convertor, sb, resSql);
            sb.delete(0, sb.length());
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
        }
        beforeFormat = resSql.toString().replaceAll("\\s+", "");
        afterFormat = SqlFormatter.format((String)resSql.toString()).replaceAll("\\s+", "");
        if (beforeFormat.equalsIgnoreCase(afterFormat)) {
            of = SqlFormatter.of((Dialect)Dialect.MySql);
            return SqlString.handleErrorRes(of.format(resSql.toString()));
        }
        return resSql.toString();
    }

    private static void convertSql(File inputFile, DatabaseConvertor convertor, StringBuilder sb, StringBuilder resSql) {
        try {
            convertor.reset();
            convertor.parse(sb.toString());
            ISqlString str = convertor.convert();
            resSql.append(str.getSql());
        }
        catch (ParserRuntimeException ex) {
            LOGGER.warn("Sql syntax not supported:{}, FileName:{}", (Object)ex.getMessage(), (Object)inputFile.getName());
            DWSMain.FAILED_SQL.incrementAndGet();
            resSql.append("/* sql not support,exceptionMessage: ").append(ex.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        }
        catch (ParserException e) {
            LOGGER.warn("Sql parser failed, FileName:{}", (Object)inputFile.getName());
            DWSMain.FAILED_SQL.incrementAndGet();
            resSql.append("/* sql not support,exceptionMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        }
        catch (Exception e) {
            LOGGER.warn("Sql convert failed, FileName:{}", (Object)inputFile.getName());
            DWSMain.FAILED_SQL.incrementAndGet();
            resSql.append("/* sql not support").append("\r\n").append((CharSequence)sb).append("*/;");
        }
    }

    private static String getBeginWithEndString(StringBuilder sb, LineIterator it, String line) {
        Matcher prMatcher = PROC_FINDER.matcher(line);
        if (prMatcher.matches()) {
            sb.append(line).append('\n');
            return null;
        }
        Matcher beginMatcher = BEGIN_FINDER.matcher(line);
        if (beginMatcher.matches()) {
            sb.append(line).append('\n');
            if (it.hasNext()) {
                line = it.nextLine();
                while (!line.trim().equalsIgnoreCase("END;")) {
                    sb.append(line).append('\n');
                    if (!it.hasNext()) break;
                    line = it.nextLine();
                }
            }
        }
        return line;
    }

    private static String getEncodingFormat() {
        String encodingFormat = null;
        encodingFormat = ApplicationPropertyLoader.getStringProperty("encodingFormat");
        if (encodingFormat.equals("")) {
            encodingFormat = "UTF8";
            LOGGER.info("Files encoding is set to default UTF8");
        }
        LOGGER.info("Files encoding is set from configuration in Application properties file : {}", (Object)encodingFormat);
        return encodingFormat;
    }

    private static boolean isSqlComment(String sql) {
        String str = sql.trim();
        if (str.startsWith("#")) {
            return true;
        }
        if (str.startsWith("--")) {
            return true;
        }
        if (str.startsWith("*")) {
            return true;
        }
        if (str.startsWith("/*")) {
            return true;
        }
        return str.startsWith("*/");
    }
}

