/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive;

import com.huawei.hwclouds.migration.hive.nodes.ColumnNameTypeConstraint;
import com.huawei.hwclouds.migration.hive.nodes.ColumnNameTypeOrConstraint;
import com.huawei.hwclouds.migration.hive.nodes.CreateTableStatement;
import com.huawei.hwclouds.migration.hive.nodes.SqlIdentifier;
import com.huawei.hwclouds.migration.hive.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.hive.nodes.TableConstraint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSPartitionKeyChooserStrategy {
    private static final Logger LOGGER = LogManager.getLogger(DWSPartitionKeyChooserStrategy.class);

    public static List<String> chooseDistributeKeyContainsConstraint(CreateTableStatement table) {
        List<String> columnsFromPrimarys = DWSPartitionKeyChooserStrategy.getPartitionColumnsFromPrimary(table);
        if (!columnsFromPrimarys.isEmpty()) {
            ArrayList<String> columns = new ArrayList<String>(columnsFromPrimarys);
            return columns;
        }
        List<String> columnsFromUniques = DWSPartitionKeyChooserStrategy.getConstraintsFromUnique(table);
        if (!columnsFromUniques.isEmpty()) {
            ArrayList<String> columns = new ArrayList<String>(columnsFromUniques);
            return columns;
        }
        List<String> defaultcolumns = DWSPartitionKeyChooserStrategy.getDefaultPartitionColumn(table);
        ArrayList<String> columns = new ArrayList<String>(defaultcolumns);
        return columns;
    }

    private static List<String> getPartitionColumnsFromPrimary(CreateTableStatement table) {
        int i;
        ArrayList<String> cols = new ArrayList<String>();
        SqlNodeList<ColumnNameTypeOrConstraint> columnNameTypeOrConstraintSqlNodeList = table.getCreateDefinition();
        for (i = 0; i < columnNameTypeOrConstraintSqlNodeList.getNodes().size(); ++i) {
            ColumnNameTypeConstraint columnNameTypeConstraint = columnNameTypeOrConstraintSqlNodeList.getNodes().get(i).getColumnNameTypeConstraint();
            if (columnNameTypeConstraint == null || columnNameTypeConstraint.getColumnConstraint() == null || !columnNameTypeConstraint.getColumnConstraint().getColConstraint().getColumnConstraintType().getTableConstraintType().isPrimaryKey()) continue;
            cols.add(columnNameTypeConstraint.getColName());
        }
        for (i = 0; i < columnNameTypeOrConstraintSqlNodeList.getNodes().size(); ++i) {
            TableConstraint tableConstraint = columnNameTypeOrConstraintSqlNodeList.getNodes().get(i).getTableConstraint();
            if (tableConstraint == null || tableConstraint.getCreateConstraint() == null || !tableConstraint.getCreateConstraint().getTableLevelConstraint().getPkUkConstraint().getTableConstraintType().isPrimaryKey()) continue;
            SqlNodeList<SqlIdentifier> columnNameList = tableConstraint.getCreateConstraint().getTableLevelConstraint().getPkUkConstraint().getColumnParenthesesList().getColumnNameList().getColumnNameList();
            for (SqlIdentifier column : columnNameList.getNodes()) {
                cols.add(column.getIdentifier());
            }
        }
        return cols;
    }

    private static List<String> getConstraintsFromUnique(CreateTableStatement table) {
        ArrayList<String> cols = new ArrayList<String>();
        SqlNodeList<ColumnNameTypeOrConstraint> columnNameTypeOrConstraintSqlNodeList = table.getCreateDefinition();
        for (int i = 0; i < columnNameTypeOrConstraintSqlNodeList.getNodes().size(); ++i) {
            if (columnNameTypeOrConstraintSqlNodeList.getNodes().get(i).getColumnNameTypeConstraint().getColumnConstraint() == null || columnNameTypeOrConstraintSqlNodeList.getNodes().get(i).getColumnNameTypeConstraint().getColumnConstraint().getColConstraint().getColumnConstraintType().getTableConstraintType().getUnique() == null) continue;
            cols.add(columnNameTypeOrConstraintSqlNodeList.getNodes().get(i).getColumnNameTypeConstraint().getColName());
        }
        return cols;
    }

    private static List<String> getDefaultPartitionColumn(CreateTableStatement table) {
        ArrayList<String> cols = new ArrayList<String>();
        SqlNodeList<ColumnNameTypeOrConstraint> columnNameTypeOrConstraintSqlNodeList = table.getCreateDefinition();
        Iterator<ColumnNameTypeOrConstraint> iterator = columnNameTypeOrConstraintSqlNodeList.getNodes().iterator();
        if (iterator.hasNext()) {
            ColumnNameTypeOrConstraint columnNameTypeOrConstraint = iterator.next();
            cols.add(columnNameTypeOrConstraint.getColumnNameTypeConstraint().getColName());
            return cols;
        }
        return cols;
    }
}

