/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.languages.Dialect;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.hive.HiveConvertor;
import com.huawei.hwclouds.migration.hive.config.HivePropertyLoader;
import com.huawei.hwclouds.migration.hive.util.SqlString;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SingleClauseConvert {
    private static final Logger LOGGER = LogManager.getLogger(SingleClauseConvert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(String originSql, Map propMap) throws ParserException {
        HiveConvertor convertor = new HiveConvertor(null);
        if (propMap == null) {
            propMap = new HashMap<String, String>();
        }
        StringBuilder sb = new StringBuilder();
        String line = originSql;
        try {
            HivePropertyLoader.loadPropertyMap(propMap);
            sb.append(line);
            convertor.reset();
            convertor.parse(sb.toString());
            ISqlString str = convertor.convert();
            sb.delete(0, sb.length());
            String beforeFormat = str.toString().replaceAll("\\s+", "");
            String afterFormat = SqlFormatter.format((String)str.toString()).replaceAll("\\s+", "");
            if (beforeFormat.equalsIgnoreCase(afterFormat)) {
                SqlFormatter.Formatter of = SqlFormatter.of((Dialect)Dialect.MySql);
                String string = SqlString.handleErrorRes(of.format(str.toString()));
                return string;
            }
            String string = str.toString();
            return string;
        }
        finally {
            HivePropertyLoader.clearPropMapCxt();
        }
    }
}

