/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.DWSPartitionKeyChooserStrategy;
import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.config.ConvertConfig;
import com.huawei.hwclouds.migration.hive.nodes.ColumnNameTypeConstraint;
import com.huawei.hwclouds.migration.hive.nodes.ColumnNameTypeOrConstraint;
import com.huawei.hwclouds.migration.hive.nodes.CreateTableStatement;
import com.huawei.hwclouds.migration.hive.nodes.DistributeOptions;
import com.huawei.hwclouds.migration.hive.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.hive.util.AppendTableName;
import com.huawei.hwclouds.migration.hive.util.ConfigUtil;
import com.huawei.hwclouds.migration.hive.util.QuoteUtils;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateTableStatement.class)
public class CreateTableStatementUnParser
implements UnParser<CreateTableStatement> {
    @Override
    public void unParse(CreateTableStatement sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE ");
        if (sqlNode.getTemporaryTable() != null) {
            writer.append(sqlNode.getTemporaryTable()).writeSpace(1);
        }
        if (sqlNode.isTransactionalTable()) {
            writer.append("TRANSACTIONAL ");
        }
        String tblType = sqlNode.getTableType();
        context.setTableType(tblType);
        if ("external".equalsIgnoreCase(tblType)) {
            writer.append("FOREIGN ");
        }
        writer.append("TABLE IF NOT EXISTS ");
        AppendTableName.appendTableName(sqlNode.getTableName(), writer, context);
        writer.writeSpace(1);
        if (sqlNode.getCreateDefinition() != null) {
            this.checkPrimaryKey(sqlNode.getCreateDefinition(), context, context.getTableName());
            writer.append("( ");
            for (int i = 0; i < sqlNode.getCreateDefinition().getNodes().size(); ++i) {
                sqlNode.getCreateDefinition().getNodes().get(i).unParse(writer, context);
                if (i == sqlNode.getCreateDefinition().getNodes().size() - 1) continue;
                writer.append(", ");
            }
            if (sqlNode.getCreateTablePartitionSpec() != null) {
                writer.append(", ").newLine();
                sqlNode.getCreateTablePartitionSpec().unParse(writer, context);
            }
            writer.append(") ");
        }
        if (sqlNode.getTableLocation() != null && "external".equalsIgnoreCase(tblType)) {
            if (sqlNode.getTableFileFormat() != null) {
                sqlNode.getTableLocation().setTableFileFormat(sqlNode.getTableFileFormat());
            }
            sqlNode.getTableLocation().unParse(writer, context);
        }
        ConvertConfig config = writer.getConfig("param.config.flag");
        this.convertOrientation(writer, config);
        if ("external".equalsIgnoreCase(tblType)) {
            writer.append("DISTRIBUTE BY ROUNDROBIN ");
        } else {
            String strategy = ConfigUtil.getConfigValue(config, "table.distribute-key.choose.strategy", null);
            if (sqlNode.getDistributeOptions() != null || strategy != null && !strategy.isEmpty()) {
                this.distributeOptionsUnParser(sqlNode, writer, context, config);
            }
        }
        if (sqlNode.getTableRowFormat() != null) {
            sqlNode.getTableRowFormat().unParse(writer, context);
        }
        if (sqlNode.getTableFileFormat() != null) {
            sqlNode.getTableFileFormat().unParse(writer, context);
        }
        if (sqlNode.getTablePropertiesPrefixed() != null) {
            sqlNode.getTablePropertiesPrefixed().unParse(writer, context);
        }
        if (sqlNode.getTableComment() != null) {
            if ("external".equalsIgnoreCase(tblType)) {
                writer.append("/* ");
            }
            writer.append("COMMENT ").append(sqlNode.getTableComment());
            if ("external".equalsIgnoreCase(tblType)) {
                writer.append(" */");
            }
        }
        if (sqlNode.getSelectStatementWithCTE() != null) {
            writer.append("AS ");
            sqlNode.getSelectStatementWithCTE().unParse(writer, context);
        }
        if (sqlNode.getCreateTablePartitionSpec() != null && "external".equalsIgnoreCase(tblType)) {
            writer.append("PARTITION BY (");
            if (sqlNode.getCreateTablePartitionSpec().getCreateTablePartitionColumnTypeSpec() != null) {
                SqlNodeList<ColumnNameTypeConstraint> columnNameTypeConstraintList = sqlNode.getCreateTablePartitionSpec().getCreateTablePartitionColumnTypeSpec().getColumnNameTypeConstraint();
                for (int i = 0; i < columnNameTypeConstraintList.getNodes().size(); ++i) {
                    writer.append(QuoteUtils.addQuote(QuoteUtils.removeAllQuote(columnNameTypeConstraintList.getNodes().get(i).getColName())));
                    if (i == columnNameTypeConstraintList.getNodes().size() - 1) continue;
                    writer.append(", ");
                }
            }
            writer.append(" ) AUTOMAPPED ");
        }
        if (sqlNode.getTableComment() != null && "external".equalsIgnoreCase(tblType)) {
            writer.sqlEnd().newLine();
            writer.append("COMMENT ON FOREIGN TABLE ");
            AppendTableName.appendTableName(sqlNode.getTableName(), writer, context);
            writer.append(" IS ").append(sqlNode.getTableComment());
        }
    }

    private void checkPrimaryKey(SqlNodeList<ColumnNameTypeOrConstraint> createDefinition, UnParserContext context, String tableName) {
        boolean existsId = false;
        boolean existsTableNameId = false;
        List<ColumnNameTypeOrConstraint> nodes = createDefinition.getNodes();
        for (ColumnNameTypeOrConstraint node : nodes) {
            String colName;
            ColumnNameTypeConstraint columnNameTypeConstraint = node.getColumnNameTypeConstraint();
            if (columnNameTypeConstraint == null) continue;
            String colNameWithOutQuote = QuoteUtils.removeAllQuote(columnNameTypeConstraint.getColName());
            if (colNameWithOutQuote.equalsIgnoreCase("id")) {
                existsId = true;
            }
            if (!colNameWithOutQuote.equalsIgnoreCase(colName = tableName + "_id")) continue;
            existsTableNameId = true;
        }
        context.setExistTwoPkCols(existsId && existsTableNameId);
    }

    private void convertOrientation(SqlWriter writer, ConvertConfig config) {
        if (!ConfigUtil.getConfigValue(config, "table.orientation", "").equalsIgnoreCase("")) {
            writer.append("WITH").writeSpace(1).append("(");
            writer.append("ORIENTATION = ").append(ConfigUtil.getConfigValue(config, "table.orientation", ""));
            if (ConfigUtil.getConfigValue(config, "table.orientation", "").equalsIgnoreCase("column")) {
                if (ConfigUtil.getConfigValue(config, "table.enable.hstore", "false").equalsIgnoreCase("true")) {
                    writer.append(", ").append("enable_hstore = true");
                }
                if (ConfigUtil.getConfigValue(config, "table.enable.hstore.opt", "false").equalsIgnoreCase("true")) {
                    writer.append(", ").append("enable_hstore_opt = true");
                }
            }
            writer.append(") ");
        }
    }

    public void distributeOptionsUnParser(CreateTableStatement sqlNode, SqlWriter writer, UnParserContext context, ConvertConfig config) {
        if (context.getPkCol() != null) {
            writer.append("DISTRIBUTE BY HASH(").append(context.getPkCol()).append(") ");
        } else {
            if (ConfigUtil.getConfigValue(config, "table.distribute-key.choose.strategy", null).equalsIgnoreCase("ROUNDROBIN")) {
                writer.append("DISTRIBUTE BY ROUNDROBIN ");
                return;
            }
            writer.append("DISTRIBUTE").writeSpace(1).append("BY").writeSpace(1);
            DistributeOptions distributeOptions = sqlNode.getDistributeOptions();
            if (distributeOptions != null && distributeOptions.getColList() == null) {
                writer.append(distributeOptions.getKeyWord()).writeSpace(1);
                return;
            }
            if (distributeOptions != null && distributeOptions.getColList().size() > 0) {
                if (distributeOptions.getKeyWord() != null) {
                    writer.append(distributeOptions.getKeyWord()).writeSpace(1);
                }
                writer.append("( ");
                int size = distributeOptions.getColList().size();
                for (int i = 0; i < size; ++i) {
                    writer.append(distributeOptions.getColList().get(i));
                    if (i == size - 1) continue;
                    writer.append(", ");
                }
                writer.append(") ");
            } else if (ConfigUtil.getConfigValue(config, "table.distribute-key.choose.strategy", null).equalsIgnoreCase("REPLICATION")) {
                writer.append("REPLICATION ");
            } else {
                this.partitionkeyUnparser(sqlNode, writer, context);
            }
        }
    }

    private void partitionkeyUnparser(CreateTableStatement sqlNode, SqlWriter writer, UnParserContext context) {
        List<String> columns = DWSPartitionKeyChooserStrategy.chooseDistributeKeyContainsConstraint(sqlNode);
        if (columns.size() > 0) {
            writer.append("HASH").writeSpace(1);
            writer.append("(");
            for (int i = 0; i < columns.size(); ++i) {
                writer.append(columns.get(i));
                if (i == columns.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
    }
}

