/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.nodes.ArrayExpressionAlias;
import com.huawei.hwclouds.migration.hive.nodes.AtomExpressionAlias;
import com.huawei.hwclouds.migration.hive.nodes.Expression;
import com.huawei.hwclouds.migration.hive.nodes.Function;
import com.huawei.hwclouds.migration.hive.nodes.Parameter;
import com.huawei.hwclouds.migration.hive.nodes.PrecedenceExpressionAlias;
import com.huawei.hwclouds.migration.hive.nodes.SimilarExpressionAlias;
import com.huawei.hwclouds.migration.hive.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.hive.nodes.SubQueryExpressionAlias;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Expression.class)
public class ExpressionUnParser
implements UnParser<Expression> {
    @Override
    public void unParse(Expression sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getLogicalExpressionAlias() != null) {
            sqlNode.getLogicalExpressionAlias().getFExpression().unParse(writer, context);
            if (sqlNode.getLogicalExpressionAlias().getOp().equalsIgnoreCase("regexp") || sqlNode.getLogicalExpressionAlias().getOp().equalsIgnoreCase("notregexp")) {
                this.dealWithRegexp(sqlNode);
            }
            writer.append(sqlNode.getLogicalExpressionAlias().getOp()).writeSpace(1);
            sqlNode.getLogicalExpressionAlias().getSExpression().unParse(writer, context);
        } else if (sqlNode.getAtomExpressionAlias() != null) {
            AtomExpressionAlias atomExpressionAlias = sqlNode.getAtomExpressionAlias();
            if (atomExpressionAlias.getNot() != null) {
                Function function = atomExpressionAlias.getAtomExpression().getFunction();
                if (function != null) {
                    function.setNot(true);
                }
                if (function == null || !"array_contains".equalsIgnoreCase(function.getFunctionName())) {
                    writer.append(atomExpressionAlias.getNot()).writeSpace(1);
                }
            }
            atomExpressionAlias.getAtomExpression().unParse(writer, context);
            if (atomExpressionAlias.getCondition() != null) {
                writer.append("IS ").append(atomExpressionAlias.getCondition()).writeSpace(1);
            }
        } else if (sqlNode.getSimilarExpressionAlias() != null) {
            SimilarExpressionAlias similarExpressionAlias = sqlNode.getSimilarExpressionAlias();
            if (similarExpressionAlias.getAtomExpression() != null) {
                similarExpressionAlias.getAtomExpression().unParse(writer, context);
            }
            if (similarExpressionAlias.isNot()) {
                writer.append("NOT ");
            }
            writer.append(similarExpressionAlias.getKeyword()).writeSpace(1);
            writer.append("( ");
            if (similarExpressionAlias.getSubQueryExpression() != null) {
                similarExpressionAlias.getSubQueryExpression().unParse(writer, context);
            } else {
                similarExpressionAlias.getExpressionsNotInParenthesis().unParse(writer, context);
            }
            writer.append(") ");
        } else if (sqlNode.getSubQueryExpressionAlias() != null) {
            SubQueryExpressionAlias subQueryExpressionAlias = sqlNode.getSubQueryExpressionAlias();
            if (subQueryExpressionAlias.isNot()) {
                writer.append("NOT ");
            }
            if (subQueryExpressionAlias.isExists()) {
                writer.append("EXISTS ");
            }
            if (subQueryExpressionAlias.getSubQuerySelectorOperator() != null) {
                writer.append(subQueryExpressionAlias.getSubQuerySelectorOperator()).writeSpace(1);
            }
            if (subQueryExpressionAlias.getQuantifierType() != null) {
                writer.append(subQueryExpressionAlias.getQuantifierType()).writeSpace(1);
            }
            writer.append("( ");
            subQueryExpressionAlias.getSubQueryExpression().unParse(writer, context);
            writer.append(") ");
        } else if (sqlNode.getPrecedenceExpressionAlias() != null) {
            PrecedenceExpressionAlias precedenceExpressionAlias = sqlNode.getPrecedenceExpressionAlias();
            if (precedenceExpressionAlias.getPrecedenceUnaryOperator() != null) {
                for (int i = 0; i < precedenceExpressionAlias.getPrecedenceUnaryOperator().size(); ++i) {
                    writer.append(precedenceExpressionAlias.getPrecedenceUnaryOperator().get(i)).writeSpace(1);
                }
            }
            precedenceExpressionAlias.getPrecedenceFieldExpression().getAtomExpression().unParse(writer, context);
            SqlNodeList<Parameter> parameterSqlNodeList = precedenceExpressionAlias.getPrecedenceFieldExpression().getParameterSqlNodeList();
            if (parameterSqlNodeList != null) {
                for (int i = 0; i < parameterSqlNodeList.getNodes().size(); ++i) {
                    parameterSqlNodeList.getNodes().get(i).unParse(writer, context);
                }
            }
        } else if (sqlNode.getBetweenExpressionAlias() != null) {
            writer.append("BETWEEN ");
            sqlNode.getBetweenExpressionAlias().getFExpression().unParse(writer, context);
            writer.append("AND ");
            sqlNode.getBetweenExpressionAlias().getSExpression().unParse(writer, context);
        } else if (sqlNode.getCastExpressionAlias() != null) {
            sqlNode.getCastExpressionAlias().getOriExpression().unParse(writer, context);
            writer.append("::");
            sqlNode.getCastExpressionAlias().getCastExpression().unParse(writer, context);
        } else if (sqlNode.getArrayExpressionAlias() != null) {
            ArrayExpressionAlias arrayExpressionAlias = sqlNode.getArrayExpressionAlias();
            writer.append("REGEXP_REPLACE(JSON_OBJECT_FIELD( ");
            arrayExpressionAlias.getExpression().unParse(writer, context);
            writer.append("::json, ");
            writer.append(arrayExpressionAlias.getConstant().getConstantValue()).append(")::varchar,'\"','','g')");
        }
    }

    private void dealWithRegexp(Expression sqlNode) {
        if ("regexp".equalsIgnoreCase(sqlNode.getLogicalExpressionAlias().getOp())) {
            sqlNode.getLogicalExpressionAlias().setOp("~*");
        } else {
            sqlNode.getLogicalExpressionAlias().setOp("!~*");
        }
    }
}

