/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.nodes.PartitionSpec;
import com.huawei.hwclouds.migration.hive.nodes.PartitionType;
import com.huawei.hwclouds.migration.hive.nodes.PartitionVal;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=PartitionSpec.class)
public class PartitionSpecUnParser
implements UnParser<PartitionSpec> {
    @Override
    public void unParse(PartitionSpec sqlNode, SqlWriter writer, UnParserContext context) {
        this.setPartitionType(sqlNode);
        List<PartitionVal> nodes = sqlNode.getPartitionValSqlNodeList().getNodes();
        if (sqlNode.getPartitionType().getValue().equalsIgnoreCase("DYNAMIC_PARTITION") && sqlNode.isInsertClause()) {
            return;
        }
        if (sqlNode.getPartitionType().getValue().equalsIgnoreCase("DYNAMIC_STATIC_PARTITION") && sqlNode.isInsertClause()) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i).getConstant() != null) continue;
                nodes.remove(i);
                i = -1;
            }
            return;
        }
        writer.append("PARTITION ");
        if (sqlNode.isInsertClause()) {
            writer.append("for ");
        }
        writer.append("( ");
        if (sqlNode.isInsertClause()) {
            if (!sqlNode.getPartitionType().getValue().equalsIgnoreCase("DYNAMIC_STATIC_PARTITION")) {
                for (int i = 0; i < nodes.size(); ++i) {
                    if (nodes.get(i).getConstant() != null) {
                        nodes.get(i).getConstant().unParse(writer, context);
                    } else {
                        writer.append(nodes.get(i).getId()).writeSpace(1);
                    }
                    if (i == nodes.size() - 1) continue;
                    writer.append(", ");
                }
            }
        } else {
            for (int i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i).getConstant() != null) {
                    writer.append(nodes.get(i).getId()).writeSpace(1);
                    writer.append("= ");
                    nodes.get(i).getConstant().unParse(writer, context);
                }
                if (i == nodes.size() - 1) continue;
                writer.append(", ");
            }
        }
        writer.append(") ");
    }

    private void setPartitionType(PartitionSpec sqlNode) {
        List<PartitionVal> nodes = sqlNode.getPartitionValSqlNodeList().getNodes();
        int staticValueCnt = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i).getConstant() == null) continue;
            ++staticValueCnt;
        }
        if (staticValueCnt == nodes.size()) {
            sqlNode.setPartitionType(PartitionType.STATIC_PARTITION);
        } else if (staticValueCnt == 0) {
            sqlNode.setPartitionType(PartitionType.DYNAMIC_PARTITION);
        } else {
            sqlNode.setPartitionType(PartitionType.DYNAMIC_STATIC_PARTITION);
        }
    }
}

