/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.config.ConvertConfig;
import com.huawei.hwclouds.migration.hive.nodes.SelectItem;
import com.huawei.hwclouds.migration.hive.util.ConfigUtil;
import com.huawei.hwclouds.migration.hive.util.QuoteUtils;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SelectItem.class)
public class SelectItemUnParser
implements UnParser<SelectItem> {
    @Override
    public void unParse(SelectItem sqlNode, SqlWriter writer, UnParserContext context) {
        context.setSelectColumn(true);
        if (sqlNode.getTableAllColumns() != null) {
            writer.append(sqlNode.getTableAllColumns()).writeSpace(1);
        } else {
            sqlNode.getExpression().unParse(writer, context);
            if (sqlNode.isAs()) {
                writer.append("AS ");
            }
            ConvertConfig config = writer.getConfig("param.config.flag");
            this.dealWithDoubleQuote(config, sqlNode);
            if (sqlNode.getIdList().size() > 1) {
                writer.append("( ");
                for (int i = 0; i < sqlNode.getIdList().size(); ++i) {
                    writer.append(sqlNode.getIdList().get(i)).writeSpace(1);
                    if (i == sqlNode.getIdList().size() - 1) continue;
                    writer.append(", ");
                }
                writer.append(") ");
            } else if (sqlNode.getIdList().size() == 1) {
                writer.append(sqlNode.getIdList().get(0)).writeSpace(1);
            }
        }
        context.setSelectColumn(false);
    }

    private void dealWithDoubleQuote(ConvertConfig config, SelectItem sqlNode) {
        int i;
        if (ConfigUtil.getConfigValue(config, "table.option.doubleQuoteForAs", "ori").equalsIgnoreCase("remove")) {
            for (i = 0; i < sqlNode.getIdList().size(); ++i) {
                sqlNode.getIdList().set(i, QuoteUtils.removeDoubleQuote(sqlNode.getIdList().get(i)));
            }
        }
        if (ConfigUtil.getConfigValue(config, "table.option.doubleQuoteForAs", "ori").equalsIgnoreCase("add")) {
            for (i = 0; i < sqlNode.getIdList().size(); ++i) {
                sqlNode.getIdList().set(i, QuoteUtils.addDoubleQuote(QuoteUtils.removeAllQuote(sqlNode.getIdList().get(i))));
            }
        }
    }
}

