/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.config.SqlDataType;
import com.huawei.hwclouds.migration.hive.nodes.ListType;
import com.huawei.hwclouds.migration.hive.nodes.PrimitiveType;
import com.huawei.hwclouds.migration.hive.nodes.Type;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Type.class)
public class TypeUnParser
implements UnParser<Type> {
    @Override
    public void unParse(Type sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getType().equalsIgnoreCase("primitiveType")) {
            TypeUnParser.dealWithPrimitiveType(sqlNode.getPrimitiveType(), writer);
        } else if (sqlNode.getType().equalsIgnoreCase("listType")) {
            if (context.getTableType() != null && context.getTableType().equalsIgnoreCase("external")) {
                writer.append("JSON ");
            } else {
                this.dealWithListType(sqlNode.getListType(), writer);
            }
        }
    }

    private void dealWithListType(ListType listType, SqlWriter writer) {
        TypeUnParser.dealWithPrimitiveType(listType.getListType().getPrimitiveType(), writer);
        writer.append("ARRAY ");
    }

    private static void dealWithPrimitiveType(PrimitiveType sqlNode, SqlWriter writer) {
        SqlDataType.writeAppendDataType(sqlNode.getTypeName(), writer);
        String precNumber = sqlNode.getPrecNumber();
        if (precNumber != null) {
            writer.append("( ");
            if ("varchar".equals(sqlNode.getTypeName().trim().toLowerCase(Locale.ROOT))) {
                writer.append(String.valueOf(Integer.parseInt(precNumber) * 4));
            } else {
                writer.append(precNumber);
            }
            if (sqlNode.getScaleNumber() != null) {
                writer.append(", ").append(sqlNode.getScaleNumber()).append(") ");
            } else {
                writer.append(") ");
            }
        }
    }
}

