/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.common.entity.PlaceHolderParam;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.scs.dws.DWSMain;
import com.huawei.hwclouds.scs.dws.MysqlConvertor;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.config.ApplicationPropertyLoader;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.util.CommonUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.util.SqlString;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMigration
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DWSMigration.class);
    private static int fileNumber = 0;
    private final File inputFile;
    private final String outputFile;
    private MysqlConvertor convertor;
    private final int range;
    private final int countValidFiles;
    private SqlDialect sourceDialect;
    private static final Pattern PROC_FINDER = Pattern.compile("(?i)^(CREATE)[\\S+\\s+]*(PROCEDURE|FUNCTION|TRIGGER)(\\s+)(.*?)");
    private static final Pattern BEGIN_FINDER = Pattern.compile("(?i)[\\S+\\s+]*begin(\\s?)");

    DWSMigration(File inFile, String outFile, int rangNum, int countValidFilesNum, SqlDialect sourceDialect) {
        this.inputFile = inFile;
        this.outputFile = outFile;
        this.range = rangNum;
        this.countValidFiles = countValidFilesNum;
        this.convertor = new MysqlConvertor(null);
        this.sourceDialect = sourceDialect;
    }

    @Override
    public void run() {
        try {
            String resSql;
            if (this.sourceDialect != null) {
                HashMap<String, String> propMap = new HashMap<String, String>();
                propMap.put("table.origin.database.type", this.sourceDialect.getValue().toLowerCase(Locale.ROOT));
                PropertyLoader.loadPropertyMap(propMap);
            }
            if ((resSql = this.parseFile(this.inputFile, this.convertor, this.range)) == null) {
                DWSMain.FAILED_FILES.incrementAndGet();
                return;
            }
            boolean fileCreate = CommonUtils.createNewFile(this.outputFile, false);
            if (!fileCreate) {
                LOGGER.error("Error while creating file");
                return;
            }
            String encodingFormat = DWSMigration.getEncodingFormat();
            FileUtils.write((File)new File(this.outputFile), (CharSequence)resSql, (String)encodingFormat);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse " + this.inputFile.getName(), (Throwable)e);
            try {
                FileUtils.copyFile((File)this.inputFile, (File)new File(this.outputFile));
            }
            catch (IOException pe) {
                LOGGER.error("Faild to copy file " + this.inputFile.getName());
            }
            DWSMain.FAILED_FILES.incrementAndGet();
        }
        int percent = 100;
        DWSMigration.incrementFileCounter();
        int status = this.countValidFiles > 0 ? fileNumber * 100 / this.countValidFiles : 0;
        DWSMain.printConsoleMessage(status + "% completed");
    }

    private static void incrementFileCounter() {
        ++fileNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String parseFile(File inputFile, MysqlConvertor convertor, int rangeNum) throws IOException {
        resSql = new StringBuilder();
        sb = new StringBuilder();
        encodingFormat = DWSMigration.getEncodingFormat();
        placeHolderParam = new PlaceHolderParam(DWSMigration.getStringValue(convertor.getConfigs(), "param.config.flag", "table.output.placeholder.format"));
        MigrationContextUtil.setPlaceHolderParam(placeHolderParam);
        validLength = rangeNum;
        it = FileUtils.lineIterator((File)inputFile, (String)encodingFormat);
        singleQuoteCnt = 0;
lbl9:
        // 2 sources

        try {
            while (it.hasNext()) {
                block15: {
                    line = it.nextLine();
                    if (line == null || !DWSMigration.isSqlComment(line)) break block15;
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    if (!line.trim().startsWith("/*")) continue;
                    if (line.trim().startsWith("*/") || line.trim().endsWith("*/") || line.trim().endsWith("*/;")) {
                        resSql.append((CharSequence)sb);
                        sb.delete(0, sb.length());
                        continue;
                    }
                    while (!line.trim().startsWith("*/") && !line.trim().endsWith("*/") && !line.trim().endsWith("*/;") && it.hasNext()) {
                        line = it.nextLine();
                        sb.append(line).append('\n');
                    }
                    ** GOTO lbl9
                }
                if ((line = DWSMigration.getBeginWithEndString(sb, it, line)) == null) continue;
                singleQuoteCnt = (int)((long)singleQuoteCnt + line.chars().filter((IntPredicate)LambdaMetafactory.metafactory(null, null, null, (I)Z, lambda$parseFile$0(int ), (I)Z)()).count());
                if (line.trim().endsWith(";") && singleQuoteCnt % 2 == 0) {
                    length = line.trim().length();
                    if (length == 1) {
                        lastInput = sb.toString().trim();
                        sb.delete(0, sb.length());
                        sb.append(lastInput);
                    }
                    sb.append(line);
                    inputLen = sb.length();
                    if (inputLen > validLength || inputLen <= 1) {
                        DWSMigration.LOGGER.error("Migration of the following file exceeds the max Sql Length: {}", (Object)inputFile.toString());
                        var14_16 = null;
                        return var14_16;
                    }
                    altString = sb.toString().toUpperCase(Locale.ROOT);
                    if (altString.contains("SET @@") || altString.contains("SET @")) {
                        sql = new StringBuilder();
                        DWSMigration.LOGGER.warn("Sql syntax not supported:PLSQL SET @@/@, FileName:" + inputFile.getName());
                        DWSMain.FAILED_SQL.incrementAndGet();
                        resSql.append((CharSequence)sql.append("/* sql not support\r\n").append((CharSequence)sb).append("*/;"));
                    } else {
                        DWSMigration.convertSql(inputFile.getName(), convertor, resSql, sb);
                        resSql.append(System.lineSeparator());
                    }
                    sb.append(System.lineSeparator());
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(line);
                if ((line == null || line.isEmpty()) && sb.toString().trim().isEmpty()) {
                    resSql.append(System.lineSeparator());
                    continue;
                }
                sb.append(System.lineSeparator());
            }
            DWSMigration.convertSql(inputFile.getName(), convertor, resSql, sb);
            sb.delete(0, sb.length());
        }
        finally {
            MigrationContextUtil.removeContext();
            LineIterator.closeQuietly((LineIterator)it);
        }
        beforeFormat = resSql.toString().replaceAll("\\s+", "");
        afterFormat = SqlFormatter.format((String)resSql.toString()).replaceAll("\\s+", "");
        if (beforeFormat.equalsIgnoreCase(afterFormat)) {
            return SqlString.handleErrorRes(SqlFormatter.format((String)resSql.toString()));
        }
        return resSql.toString();
    }

    public static void convertSql(String inputFileName, DatabaseConvertor convertor, StringBuilder resSql, StringBuilder sb) {
        try {
            ISqlString str = null;
            convertor.reset();
            convertor.parse(sb.toString());
            str = convertor.convert();
            resSql.append(str.getSql());
        }
        catch (Exception e) {
            DWSMigration.handleException(e, resSql, inputFileName, sb);
        }
    }

    private static void handleException(Exception e, StringBuilder resSql, String inputFile, StringBuilder sb) {
        if (e instanceof ParserRuntimeException) {
            ParserRuntimeException exception = (ParserRuntimeException)e;
            LOGGER.error("Sql syntax not supported,exceptionCode:[{}],exceptionMessage:[{}],FileName:{}.", (Object)exception.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql syntax not supported, errorCode: ").append(exception.getExceptionCode()).append(", errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        } else if (e instanceof ParserException) {
            LOGGER.error("Sql parser failed, exceptionCode:[{}],exceptionMessage:[{}],FileName:[{}]", (Object)ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql parser failed, errorCode: ").append(ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode()).append(", errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        } else {
            LOGGER.error("Sql convert failed, exceptionCode:[{}],exceptionMessage:[{}],FileName:[{}]", (Object)ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql parser failed, errorCode: ").append(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode()).append(", errorMessage: ").append(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionMessage(new Object[0])).append("\r\n").append((CharSequence)sb).append("*/;");
        }
    }

    public static String getBeginWithEndString(StringBuilder sb, LineIterator it, String line) {
        Matcher prMatcher = PROC_FINDER.matcher(line);
        if (prMatcher.matches()) {
            sb.append(line).append('\n');
            return null;
        }
        Matcher beginMatcher = BEGIN_FINDER.matcher(line);
        if (beginMatcher.matches()) {
            sb.append(line).append('\n');
            if (it.hasNext()) {
                line = it.nextLine();
                while (!line.trim().equalsIgnoreCase("END;")) {
                    sb.append(line).append('\n');
                    if (!it.hasNext()) break;
                    line = it.nextLine();
                }
            }
        }
        return line;
    }

    private static String getEncodingFormat() {
        String encodingFormat = null;
        encodingFormat = ApplicationPropertyLoader.getStringProperty("encodingFormat");
        if (encodingFormat.equals("")) {
            encodingFormat = "UTF8";
            LOGGER.info("Files encoding is set to default UTF8");
        }
        LOGGER.info("Files encoding is set from configuration in Application properties file : {}", (Object)encodingFormat);
        return encodingFormat;
    }

    public static boolean isSqlComment(String sql) {
        String str = sql.trim();
        if (str.startsWith("#")) {
            return true;
        }
        if (str.startsWith("--")) {
            return true;
        }
        if (str.startsWith("*")) {
            return true;
        }
        if (str.startsWith("/*")) {
            String dealSql = sql.trim();
            String leftWithSpace = dealSql.replaceAll("[/*]", "");
            String rightWithSpace = dealSql.replaceAll("[*/]", "");
            return leftWithSpace.length() != rightWithSpace.length() || leftWithSpace.length() <= 0 || sql.endsWith("*/") || sql.endsWith("*/;");
        }
        return str.startsWith("*/");
    }

    private static void getResSql(DatabaseConvertor convertor, StringBuilder resSql, String inputFile, StringBuilder sb) {
        try {
            convertor.reset();
            convertor.parse(sb.toString());
            ISqlString str = null;
            str = convertor.convert();
            resSql.append(str.getSql());
        }
        catch (ParserRuntimeException ex) {
            LOGGER.warn("Sql syntax not supported:" + ex.getMessage() + ", FileName:" + inputFile + ", OriSql:" + sb.toString());
            resSql.append("/* sql not support\r\n" + sb.toString() + "*/;");
        }
        catch (ParserException e) {
            LOGGER.warn("Sql parser failed, FileName:" + inputFile + ", OriSql:" + sb.toString());
            resSql.append("/* sql not support\r\n" + sb.toString() + "*/;");
        }
        catch (Exception e) {
            LOGGER.warn("Sql convert failed, FileName:" + inputFile + ", OriSql:" + sb.toString());
            resSql.append("/* sql not support\r\n" + sb.toString() + "*/;");
        }
    }

    public static String getStringValue(Map<String, ConvertConfig> configs, String configKey, String paramKey) {
        ConvertConfig dwsConfig = configs.get(configKey.toUpperCase(Locale.ROOT));
        if (dwsConfig != null) {
            return dwsConfig.getStringValue(paramKey);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$parseFile$0(int c) {
        return c == 39;
    }
}

